package org.jboss.shrinkwrap.descriptor.api.jbossweb60; 

import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Child;
import org.jboss.shrinkwrap.descriptor.api.jbossweb60.EmptyRoleSemanticType;
import org.jboss.shrinkwrap.descriptor.api.webcommon30.TransportGuaranteeType;
/**
 * This interface defines the contract for the <code> http-method-constraintType </code> xsd type 
 * @author <a href="mailto:ralf.battenfeld@bluewin.ch">Ralf Battenfeld</a>
 * @author <a href="mailto:alr@jboss.org">Andrew Lee Rubinger</a>
 */
public interface HttpMethodConstraintType<T> extends Child<T> { 

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: HttpMethodConstraintType ElementName: xsd:token ElementType : method
   // MaxOccurs: -1  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>method</code> element
    * @param method the value for the element <code>method</code> 
    * @return the current instance of <code>HttpMethodConstraintType<T></code> 
    */
   public HttpMethodConstraintType<T> method(String method);

   /**
    * Returns the <code>method</code> element
    * @return the node defined for the element <code>method</code> 
    */
   public String getMethod();

   /**
    * Removes the <code>method</code> element 
    * @return the current instance of <code>HttpMethodConstraintType<T></code> 
    */
   public HttpMethodConstraintType<T> removeMethod();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: HttpMethodConstraintType ElementName: jboss:empty-role-semanticType ElementType : empty-role-semantic
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: true isDataType: false
   // --------------------------------------------------------------------------------------------------------||
   /**
    * Sets the <code>empty-role-semantic</code> element
    * @param emptyRoleSemantic the value for the element <code>empty-role-semantic</code> 
    * @return the current instance of <code>HttpMethodConstraintType<T></code> 
    */
   public HttpMethodConstraintType<T> emptyRoleSemantic(EmptyRoleSemanticType emptyRoleSemantic);
   /**
    * Sets the <code>empty-role-semantic</code> element
    * @param emptyRoleSemantic the value for the element <code>empty-role-semantic</code> 
    * @return the current instance of <code>HttpMethodConstraintType<T></code> 
    */
   public HttpMethodConstraintType<T> emptyRoleSemantic(String emptyRoleSemantic);

   /**
    * Returns the <code>empty-role-semantic</code> element
    * @return the value found for the element <code>empty-role-semantic</code> 
    */
   public EmptyRoleSemanticType getEmptyRoleSemantic();

   /**
    * Returns the <code>empty-role-semantic</code> element
    * @return the value found for the element <code>empty-role-semantic</code> 
    */
   public String  getEmptyRoleSemanticAsString();

   /**
    * Removes the <code>empty-role-semantic</code> attribute 
    * @return the current instance of <code>HttpMethodConstraintType<T></code> 
    */
   public HttpMethodConstraintType<T> removeEmptyRoleSemantic();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: HttpMethodConstraintType ElementName: javaee:transport-guaranteeType ElementType : transport-guarantee
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: true isDataType: false
   // --------------------------------------------------------------------------------------------------------||
   /**
    * Sets the <code>transport-guarantee</code> element
    * @param transportGuarantee the value for the element <code>transport-guarantee</code> 
    * @return the current instance of <code>HttpMethodConstraintType<T></code> 
    */
   public HttpMethodConstraintType<T> transportGuarantee(TransportGuaranteeType transportGuarantee);
   /**
    * Sets the <code>transport-guarantee</code> element
    * @param transportGuarantee the value for the element <code>transport-guarantee</code> 
    * @return the current instance of <code>HttpMethodConstraintType<T></code> 
    */
   public HttpMethodConstraintType<T> transportGuarantee(String transportGuarantee);

   /**
    * Returns the <code>transport-guarantee</code> element
    * @return the value found for the element <code>transport-guarantee</code> 
    */
   public TransportGuaranteeType getTransportGuarantee();

   /**
    * Returns the <code>transport-guarantee</code> element
    * @return the value found for the element <code>transport-guarantee</code> 
    */
   public String  getTransportGuaranteeAsString();

   /**
    * Removes the <code>transport-guarantee</code> attribute 
    * @return the current instance of <code>HttpMethodConstraintType<T></code> 
    */
   public HttpMethodConstraintType<T> removeTransportGuarantee();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: HttpMethodConstraintType ElementName: xsd:token ElementType : roles-allowed
   // MaxOccurs: -unbounded  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Creates for all String objects representing <code>roles-allowed</code> elements, 
    * a new <code>roles-allowed</code> element 
    * @param values list of <code>roles-allowed</code> objects 
    * @return the current instance of <code>HttpMethodConstraintType<T></code> 
    */
   public HttpMethodConstraintType<T> rolesAllowed(String ... values);

   /**
    * Returns all <code>roles-allowed</code> elements
    * @return list of <code>roles-allowed</code> 
    */
   public List<String> getAllRolesAllowed();

   /**
    * Removes the <code>roles-allowed</code> element 
    * @return the current instance of <code>HttpMethodConstraintType<T></code> 
    */
   public HttpMethodConstraintType<T> removeAllRolesAllowed();
}
