package org.jboss.shrinkwrap.descriptor.api.wildflyfeaturepack11; 

import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Child;
/**
 * This interface defines the contract for the <code> filter-type </code> xsd type 
 * @author <a href="mailto:bmcwhirt@redhat.com">Bob McWhirter</a>
 * @author <a href="mailto:alr@jboss.org">Andrew Lee Rubinger</a>
 */
public interface FilterType<T> extends Child<T> { 

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: FilterType ElementName: xsd:string ElementType : pattern
   // MaxOccurs: -  isGeneric: true   isAttribute: true isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>pattern</code> attribute
    * @param pattern the value for the attribute <code>pattern</code> 
    * @return the current instance of <code>FilterType<T></code> 
    */
   public FilterType<T> pattern(String pattern);

   /**
    * Returns the <code>pattern</code> attribute
    * @return the value defined for the attribute <code>pattern</code> 
    */
   public String getPattern();

   /**
    * Removes the <code>pattern</code> attribute 
    * @return the current instance of <code>FilterType<T></code> 
    */
   public FilterType<T> removePattern();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: FilterType ElementName: xsd:boolean ElementType : include
   // MaxOccurs: -  isGeneric: true   isAttribute: true isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>include</code> attribute
    * @param include the value for the attribute <code>include</code> 
    * @return the current instance of <code>FilterType<T></code> 
    */
   public FilterType<T> include(Boolean include);

   /**
    * Returns the <code>include</code> attribute
    * @return the value defined for the attribute <code>include</code> 
    */
public Boolean isInclude();

   /**
    * Removes the <code>include</code> attribute 
    * @return the current instance of <code>FilterType<T></code> 
    */
   public FilterType<T> removeInclude();
}
