package org.jboss.shrinkwrap.descriptor.impl.jboss51; 

import org.jboss.shrinkwrap.descriptor.spi.node.Node;
import org.jboss.shrinkwrap.descriptor.api.jboss51.AnnotationType;
import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Child;
import org.jboss.shrinkwrap.descriptor.impl.base.XMLDate;
import org.jboss.shrinkwrap.descriptor.impl.base.Strings;
import org.jboss.shrinkwrap.descriptor.api.DescriptorExporter;
import org.jboss.shrinkwrap.descriptor.api.jbosscommon51.InjectionTargetType;
import org.jboss.shrinkwrap.descriptor.impl.jbosscommon51.InjectionTargetTypeImpl;
import org.jboss.shrinkwrap.descriptor.api.jboss51.AnnotationPropertyType;
import org.jboss.shrinkwrap.descriptor.impl.jboss51.AnnotationPropertyTypeImpl;

/**
 * This class implements the <code> annotationType </code> xsd type 
 * @author <a href="mailto:ralf.battenfeld@bluewin.ch">Ralf Battenfeld</a>
 * @author <a href="mailto:alr@jboss.org">Andrew Lee Rubinger</a>
 */
public class AnnotationTypeImpl<T> implements Child<T>, AnnotationType<T>
{
   // -------------------------------------------------------------------------------------||
   // Instance Members 
   // -------------------------------------------------------------------------------------||

   private T t;
   private Node childNode;
   // -------------------------------------------------------------------------------------||
   // Constructor 
   // -------------------------------------------------------------------------------------||

   public AnnotationTypeImpl(T t, String nodeName, Node node)   {
      this.t = t;
      this.childNode = node.createChild(nodeName);
   }

   public AnnotationTypeImpl(T t, String nodeName, Node node, Node childNode)   {
      this.t = t;
      this.childNode = childNode;
   }


   public T up()
   {
      return t;
   }


 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: AnnotationType ElementName: xsd:string ElementType : description
   // MaxOccurs: -unbounded  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Creates for all String objects representing <code>description</code> elements, 
    * a new <code>description</code> element 
    * @param values list of <code>description</code> objects 
    * @return the current instance of <code>AnnotationType<T></code> 
    */
   public AnnotationType<T> description(String ... values)
   {
      if (values != null)
      {
         for(String name: values)
         {
            childNode.createChild("description").text(name);
         }
      }
      return this;
   }

   /**
    * Returns all <code>description</code> elements
    * @return list of <code>description</code> 
    */
public List<String> getAllDescription()
   {
      List<String> result = new ArrayList<String>();
      List<Node> nodes = childNode.get("description");
      for (Node node : nodes)
      {
         result.add(node.getText());
      }
      return result;
   }

   /**
    * Removes the <code>description</code> element 
    * @return the current instance of <code>AnnotationType<T></code> 
    */
   public AnnotationType<T> removeAllDescription()
   {
      childNode.removeChildren("description");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: AnnotationType ElementName: javaee:fully-qualified-classType ElementType : annotation-class
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>annotation-class</code> element
    * @param annotationClass the value for the element <code>annotation-class</code> 
    * @return the current instance of <code>AnnotationType<T></code> 
    */
   public AnnotationType<T> annotationClass(String annotationClass)
   {
      childNode.getOrCreate("annotation-class").text(annotationClass);
      return this;
   }

   /**
    * Returns the <code>annotation-class</code> element
    * @return the node defined for the element <code>annotation-class</code> 
    */
   public String getAnnotationClass()
   {
      return childNode.getTextValueForPatternName("annotation-class");
   }

   /**
    * Removes the <code>annotation-class</code> element 
    * @return the current instance of <code>AnnotationType<T></code> 
    */
   public AnnotationType<T> removeAnnotationClass()
   {
      childNode.removeChildren("annotation-class");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: AnnotationType ElementName: javaee:fully-qualified-classType ElementType : annotation-implementation-class
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>annotation-implementation-class</code> element
    * @param annotationImplementationClass the value for the element <code>annotation-implementation-class</code> 
    * @return the current instance of <code>AnnotationType<T></code> 
    */
   public AnnotationType<T> annotationImplementationClass(String annotationImplementationClass)
   {
      childNode.getOrCreate("annotation-implementation-class").text(annotationImplementationClass);
      return this;
   }

   /**
    * Returns the <code>annotation-implementation-class</code> element
    * @return the node defined for the element <code>annotation-implementation-class</code> 
    */
   public String getAnnotationImplementationClass()
   {
      return childNode.getTextValueForPatternName("annotation-implementation-class");
   }

   /**
    * Removes the <code>annotation-implementation-class</code> element 
    * @return the current instance of <code>AnnotationType<T></code> 
    */
   public AnnotationType<T> removeAnnotationImplementationClass()
   {
      childNode.removeChildren("annotation-implementation-class");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: AnnotationType ElementName: jboss:injection-targetType ElementType : injection-target
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>injection-target</code> element with the given value will be created.
    * Otherwise, the existing <code>injection-target</code> element will be returned.
    * @return  a new or existing instance of <code>InjectionTargetType<AnnotationType<T>></code> 
    */
   public InjectionTargetType<AnnotationType<T>> getOrCreateInjectionTarget()
   {
      Node node = childNode.getOrCreate("injection-target");
      InjectionTargetType<AnnotationType<T>> injectionTarget = new InjectionTargetTypeImpl<AnnotationType<T>>(this, "injection-target", childNode, node);
      return injectionTarget;
   }

   /**
    * Removes the <code>injection-target</code> element 
    * @return the current instance of <code>AnnotationType<T></code> 
    */
   public AnnotationType<T> removeInjectionTarget()
   {
      childNode.removeChildren("injection-target");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: AnnotationType ElementName: jboss:annotation-propertyType ElementType : property
   // MaxOccurs: -unbounded  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>property</code> element will be created and returned.
    * Otherwise, the first existing <code>property</code> element will be returned.
    * @return the instance defined for the element <code>property</code> 
    */
   public AnnotationPropertyType<AnnotationType<T>> getOrCreateProperty()
   {
      List<Node> nodeList = childNode.get("property");
      if (nodeList != null &&  nodeList.size() > 0)
      {
         return new AnnotationPropertyTypeImpl<AnnotationType<T>>(this, "property", childNode, nodeList.get(0));
      }
      return createProperty();
   }

   /**
    * Creates a new <code>property</code> element 
    * @return the new created instance of <code>AnnotationPropertyType<AnnotationType<T>></code> 
    */
   public AnnotationPropertyType<AnnotationType<T>> createProperty()
   {
      return new AnnotationPropertyTypeImpl<AnnotationType<T>>(this, "property", childNode);
   }

   /**
    * Returns all <code>property</code> elements
    * @return list of <code>property</code> 
    */
   public List<AnnotationPropertyType<AnnotationType<T>>> getAllProperty()
   {
      List<AnnotationPropertyType<AnnotationType<T>>> list = new ArrayList<AnnotationPropertyType<AnnotationType<T>>>();
      List<Node> nodeList = childNode.get("property");
      for(Node node: nodeList)
      {
         AnnotationPropertyType<AnnotationType<T>>  type = new AnnotationPropertyTypeImpl<AnnotationType<T>>(this, "property", childNode, node);
         list.add(type);
      }
      return list;
   }

   /**
    * Removes all <code>property</code> elements 
    * @return the current instance of <code>AnnotationPropertyType<AnnotationType<T>></code> 
    */
   public AnnotationType<T> removeAllProperty()
   {
      childNode.removeChildren("property");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: AnnotationType ElementName: xsd:ID ElementType : id
   // MaxOccurs: -  isGeneric: true   isAttribute: true isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>id</code> attribute
    * @param id the value for the attribute <code>id</code> 
    * @return the current instance of <code>AnnotationType<T></code> 
    */
   public AnnotationType<T> id(String id)
   {
      childNode.attribute("id", id);
      return this;
   }

   /**
    * Returns the <code>id</code> attribute
    * @return the value defined for the attribute <code>id</code> 
    */
      public String getId()
   {
      return childNode.getAttribute("id");
   }

   /**
    * Removes the <code>id</code> attribute 
    * @return the current instance of <code>AnnotationType<T></code> 
    */
   public AnnotationType<T> removeId()
   {
      childNode.removeAttribute("id");
      return this;
   }
}
