package org.jboss.shrinkwrap.descriptor.impl.jboss51; 

import org.jboss.shrinkwrap.descriptor.spi.node.Node;
import org.jboss.shrinkwrap.descriptor.api.jboss51.ResourceManagerType;
import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Child;
import org.jboss.shrinkwrap.descriptor.impl.base.XMLDate;
import org.jboss.shrinkwrap.descriptor.impl.base.Strings;
import org.jboss.shrinkwrap.descriptor.api.DescriptorExporter;

/**
 * This class implements the <code> resource-managerType </code> xsd type 
 * @author <a href="mailto:ralf.battenfeld@bluewin.ch">Ralf Battenfeld</a>
 * @author <a href="mailto:alr@jboss.org">Andrew Lee Rubinger</a>
 */
public class ResourceManagerTypeImpl<T> implements Child<T>, ResourceManagerType<T>
{
   // -------------------------------------------------------------------------------------||
   // Instance Members 
   // -------------------------------------------------------------------------------------||

   private T t;
   private Node childNode;
   // -------------------------------------------------------------------------------------||
   // Constructor 
   // -------------------------------------------------------------------------------------||

   public ResourceManagerTypeImpl(T t, String nodeName, Node node)   {
      this.t = t;
      this.childNode = node.createChild(nodeName);
   }

   public ResourceManagerTypeImpl(T t, String nodeName, Node node, Node childNode)   {
      this.t = t;
      this.childNode = childNode;
   }


   public T up()
   {
      return t;
   }


 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ResourceManagerType ElementName: xsd:string ElementType : description
   // MaxOccurs: -unbounded  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Creates for all String objects representing <code>description</code> elements, 
    * a new <code>description</code> element 
    * @param values list of <code>description</code> objects 
    * @return the current instance of <code>ResourceManagerType<T></code> 
    */
   public ResourceManagerType<T> description(String ... values)
   {
      if (values != null)
      {
         for(String name: values)
         {
            childNode.createChild("description").text(name);
         }
      }
      return this;
   }

   /**
    * Returns all <code>description</code> elements
    * @return list of <code>description</code> 
    */
public List<String> getAllDescription()
   {
      List<String> result = new ArrayList<String>();
      List<Node> nodes = childNode.get("description");
      for (Node node : nodes)
      {
         result.add(node.getText());
      }
      return result;
   }

   /**
    * Removes the <code>description</code> element 
    * @return the current instance of <code>ResourceManagerType<T></code> 
    */
   public ResourceManagerType<T> removeAllDescription()
   {
      childNode.removeChildren("description");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ResourceManagerType ElementName: xsd:string ElementType : res-name
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>res-name</code> element
    * @param resName the value for the element <code>res-name</code> 
    * @return the current instance of <code>ResourceManagerType<T></code> 
    */
   public ResourceManagerType<T> resName(String resName)
   {
      childNode.getOrCreate("res-name").text(resName);
      return this;
   }

   /**
    * Returns the <code>res-name</code> element
    * @return the node defined for the element <code>res-name</code> 
    */
   public String getResName()
   {
      return childNode.getTextValueForPatternName("res-name");
   }

   /**
    * Removes the <code>res-name</code> element 
    * @return the current instance of <code>ResourceManagerType<T></code> 
    */
   public ResourceManagerType<T> removeResName()
   {
      childNode.removeChildren("res-name");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ResourceManagerType ElementName: xsd:string ElementType : res-jndi-name
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>res-jndi-name</code> element
    * @param resJndiName the value for the element <code>res-jndi-name</code> 
    * @return the current instance of <code>ResourceManagerType<T></code> 
    */
   public ResourceManagerType<T> resJndiName(String resJndiName)
   {
      childNode.getOrCreate("res-jndi-name").text(resJndiName);
      return this;
   }

   /**
    * Returns the <code>res-jndi-name</code> element
    * @return the node defined for the element <code>res-jndi-name</code> 
    */
   public String getResJndiName()
   {
      return childNode.getTextValueForPatternName("res-jndi-name");
   }

   /**
    * Removes the <code>res-jndi-name</code> element 
    * @return the current instance of <code>ResourceManagerType<T></code> 
    */
   public ResourceManagerType<T> removeResJndiName()
   {
      childNode.removeChildren("res-jndi-name");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ResourceManagerType ElementName: xsd:string ElementType : res-url
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>res-url</code> element
    * @param resUrl the value for the element <code>res-url</code> 
    * @return the current instance of <code>ResourceManagerType<T></code> 
    */
   public ResourceManagerType<T> resUrl(String resUrl)
   {
      childNode.getOrCreate("res-url").text(resUrl);
      return this;
   }

   /**
    * Returns the <code>res-url</code> element
    * @return the node defined for the element <code>res-url</code> 
    */
   public String getResUrl()
   {
      return childNode.getTextValueForPatternName("res-url");
   }

   /**
    * Removes the <code>res-url</code> element 
    * @return the current instance of <code>ResourceManagerType<T></code> 
    */
   public ResourceManagerType<T> removeResUrl()
   {
      childNode.removeChildren("res-url");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ResourceManagerType ElementName: xsd:ID ElementType : id
   // MaxOccurs: -  isGeneric: true   isAttribute: true isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>id</code> attribute
    * @param id the value for the attribute <code>id</code> 
    * @return the current instance of <code>ResourceManagerType<T></code> 
    */
   public ResourceManagerType<T> id(String id)
   {
      childNode.attribute("id", id);
      return this;
   }

   /**
    * Returns the <code>id</code> attribute
    * @return the value defined for the attribute <code>id</code> 
    */
      public String getId()
   {
      return childNode.getAttribute("id");
   }

   /**
    * Removes the <code>id</code> attribute 
    * @return the current instance of <code>ResourceManagerType<T></code> 
    */
   public ResourceManagerType<T> removeId()
   {
      childNode.removeAttribute("id");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ResourceManagerType ElementName: xsd:string ElementType : res-class
   // MaxOccurs: -  isGeneric: true   isAttribute: true isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>res-class</code> attribute
    * @param resClass the value for the attribute <code>res-class</code> 
    * @return the current instance of <code>ResourceManagerType<T></code> 
    */
   public ResourceManagerType<T> resClass(String resClass)
   {
      childNode.attribute("res-class", resClass);
      return this;
   }

   /**
    * Returns the <code>res-class</code> attribute
    * @return the value defined for the attribute <code>res-class</code> 
    */
      public String getResClass()
   {
      return childNode.getAttribute("res-class");
   }

   /**
    * Removes the <code>res-class</code> attribute 
    * @return the current instance of <code>ResourceManagerType<T></code> 
    */
   public ResourceManagerType<T> removeResClass()
   {
      childNode.removeAttribute("res-class");
      return this;
   }
}
