package org.jboss.shrinkwrap.descriptor.impl.jbossdeployment10; 

import org.jboss.shrinkwrap.descriptor.spi.node.Node;
import org.jboss.shrinkwrap.descriptor.api.jbossdeployment10.ModuleDependencyType;
import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Child;
import org.jboss.shrinkwrap.descriptor.impl.base.XMLDate;
import org.jboss.shrinkwrap.descriptor.impl.base.Strings;
import org.jboss.shrinkwrap.descriptor.api.DescriptorExporter;
import org.jboss.shrinkwrap.descriptor.api.jbossdeployment10.FilterType;
import org.jboss.shrinkwrap.descriptor.impl.jbossdeployment10.FilterTypeImpl;
import org.jboss.shrinkwrap.descriptor.api.jbossdeployment10.FilterType;
import org.jboss.shrinkwrap.descriptor.impl.jbossdeployment10.FilterTypeImpl;
import org.jboss.shrinkwrap.descriptor.api.jbossdeployment10.ServiceDispositionType;

/**
 * This class implements the <code> moduleDependencyType </code> xsd type 
 * @author <a href="mailto:ralf.battenfeld@bluewin.ch">Ralf Battenfeld</a>
 * @author <a href="mailto:alr@jboss.org">Andrew Lee Rubinger</a>
 */
public class ModuleDependencyTypeImpl<T> implements Child<T>, ModuleDependencyType<T>
{
   // -------------------------------------------------------------------------------------||
   // Instance Members 
   // -------------------------------------------------------------------------------------||

   private T t;
   private Node childNode;
   // -------------------------------------------------------------------------------------||
   // Constructor 
   // -------------------------------------------------------------------------------------||

   public ModuleDependencyTypeImpl(T t, String nodeName, Node node)   {
      this.t = t;
      this.childNode = node.createChild(nodeName);
   }

   public ModuleDependencyTypeImpl(T t, String nodeName, Node node, Node childNode)   {
      this.t = t;
      this.childNode = childNode;
   }


   public T up()
   {
      return t;
   }


 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ModuleDependencyType ElementName: jboss:filterType ElementType : exports
   // MaxOccurs: -unbounded  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>exports</code> element will be created and returned.
    * Otherwise, the first existing <code>exports</code> element will be returned.
    * @return the instance defined for the element <code>exports</code> 
    */
   public FilterType<ModuleDependencyType<T>> getOrCreateExports()
   {
      List<Node> nodeList = childNode.get("exports");
      if (nodeList != null &&  nodeList.size() > 0)
      {
         return new FilterTypeImpl<ModuleDependencyType<T>>(this, "exports", childNode, nodeList.get(0));
      }
      return createExports();
   }

   /**
    * Creates a new <code>exports</code> element 
    * @return the new created instance of <code>FilterType<ModuleDependencyType<T>></code> 
    */
   public FilterType<ModuleDependencyType<T>> createExports()
   {
      return new FilterTypeImpl<ModuleDependencyType<T>>(this, "exports", childNode);
   }

   /**
    * Returns all <code>exports</code> elements
    * @return list of <code>exports</code> 
    */
   public List<FilterType<ModuleDependencyType<T>>> getAllExports()
   {
      List<FilterType<ModuleDependencyType<T>>> list = new ArrayList<FilterType<ModuleDependencyType<T>>>();
      List<Node> nodeList = childNode.get("exports");
      for(Node node: nodeList)
      {
         FilterType<ModuleDependencyType<T>>  type = new FilterTypeImpl<ModuleDependencyType<T>>(this, "exports", childNode, node);
         list.add(type);
      }
      return list;
   }

   /**
    * Removes all <code>exports</code> elements 
    * @return the current instance of <code>FilterType<ModuleDependencyType<T>></code> 
    */
   public ModuleDependencyType<T> removeAllExports()
   {
      childNode.removeChildren("exports");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ModuleDependencyType ElementName: jboss:filterType ElementType : imports
   // MaxOccurs: -unbounded  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>imports</code> element will be created and returned.
    * Otherwise, the first existing <code>imports</code> element will be returned.
    * @return the instance defined for the element <code>imports</code> 
    */
   public FilterType<ModuleDependencyType<T>> getOrCreateImports()
   {
      List<Node> nodeList = childNode.get("imports");
      if (nodeList != null &&  nodeList.size() > 0)
      {
         return new FilterTypeImpl<ModuleDependencyType<T>>(this, "imports", childNode, nodeList.get(0));
      }
      return createImports();
   }

   /**
    * Creates a new <code>imports</code> element 
    * @return the new created instance of <code>FilterType<ModuleDependencyType<T>></code> 
    */
   public FilterType<ModuleDependencyType<T>> createImports()
   {
      return new FilterTypeImpl<ModuleDependencyType<T>>(this, "imports", childNode);
   }

   /**
    * Returns all <code>imports</code> elements
    * @return list of <code>imports</code> 
    */
   public List<FilterType<ModuleDependencyType<T>>> getAllImports()
   {
      List<FilterType<ModuleDependencyType<T>>> list = new ArrayList<FilterType<ModuleDependencyType<T>>>();
      List<Node> nodeList = childNode.get("imports");
      for(Node node: nodeList)
      {
         FilterType<ModuleDependencyType<T>>  type = new FilterTypeImpl<ModuleDependencyType<T>>(this, "imports", childNode, node);
         list.add(type);
      }
      return list;
   }

   /**
    * Removes all <code>imports</code> elements 
    * @return the current instance of <code>FilterType<ModuleDependencyType<T>></code> 
    */
   public ModuleDependencyType<T> removeAllImports()
   {
      childNode.removeChildren("imports");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ModuleDependencyType ElementName: xsd:string ElementType : name
   // MaxOccurs: -  isGeneric: true   isAttribute: true isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>name</code> attribute
    * @param name the value for the attribute <code>name</code> 
    * @return the current instance of <code>ModuleDependencyType<T></code> 
    */
   public ModuleDependencyType<T> name(String name)
   {
      childNode.attribute("name", name);
      return this;
   }

   /**
    * Returns the <code>name</code> attribute
    * @return the value defined for the attribute <code>name</code> 
    */
      public String getName()
   {
      return childNode.getAttribute("name");
   }

   /**
    * Removes the <code>name</code> attribute 
    * @return the current instance of <code>ModuleDependencyType<T></code> 
    */
   public ModuleDependencyType<T> removeName()
   {
      childNode.removeAttribute("name");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ModuleDependencyType ElementName: xsd:string ElementType : slot
   // MaxOccurs: -  isGeneric: true   isAttribute: true isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>slot</code> attribute
    * @param slot the value for the attribute <code>slot</code> 
    * @return the current instance of <code>ModuleDependencyType<T></code> 
    */
   public ModuleDependencyType<T> slot(String slot)
   {
      childNode.attribute("slot", slot);
      return this;
   }

   /**
    * Returns the <code>slot</code> attribute
    * @return the value defined for the attribute <code>slot</code> 
    */
      public String getSlot()
   {
      return childNode.getAttribute("slot");
   }

   /**
    * Removes the <code>slot</code> attribute 
    * @return the current instance of <code>ModuleDependencyType<T></code> 
    */
   public ModuleDependencyType<T> removeSlot()
   {
      childNode.removeAttribute("slot");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ModuleDependencyType ElementName: xsd:boolean ElementType : export
   // MaxOccurs: -  isGeneric: true   isAttribute: true isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>export</code> attribute
    * @param export the value for the attribute <code>export</code> 
    * @return the current instance of <code>ModuleDependencyType<T></code> 
    */
   public ModuleDependencyType<T> export(Boolean export)
   {
      childNode.attribute("export", export);
      return this;
   }

   /**
    * Returns the <code>export</code> attribute
    * @return the value defined for the attribute <code>export</code> 
    */
   public Boolean isExport()
   {
      return Strings.isTrue(childNode.getAttribute("export"));
   }

   /**
    * Removes the <code>export</code> attribute 
    * @return the current instance of <code>ModuleDependencyType<T></code> 
    */
   public ModuleDependencyType<T> removeExport()
   {
      childNode.removeAttribute("export");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ModuleDependencyType ElementName: jboss:serviceDispositionType ElementType : services
   // MaxOccurs: -  isGeneric: true   isAttribute: true isEnum: true isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>services</code> attribute
    * @param services the value for the attribute <code>services</code> 
    * @return the current instance of <code>ModuleDependencyType<T></code> 
    */
   public ModuleDependencyType<T> services(ServiceDispositionType services)
   {
      childNode.attribute("services", services);
      return this;
   }

   /**
    * Sets the <code>services</code> attribute
    * @param services the value for the attribute <code>services</code> 
    * @return the current instance of <code>ModuleDependencyType<T></code> 
    */
   public ModuleDependencyType<T> services(String services)
   {
      childNode.attribute("services", services);
      return this;
   }

   /**
    * Returns the <code>services</code> attribute
    * @return the value defined for the attribute <code>services</code> 
    */
   public ServiceDispositionType getServices()
   {
      return ServiceDispositionType.getFromStringValue(childNode.getAttribute("services"));
   }

   /**
    * Returns the <code>services</code> attribute
    * @return the value found for the element <code>services</code> 
    */
   public String  getServicesAsString()
   {
      return childNode.getAttribute("services");
   }

   /**
    * Removes the <code>services</code> attribute 
    * @return the current instance of <code>ModuleDependencyType<T></code> 
    */
   public ModuleDependencyType<T> removeServices()
   {
      childNode.removeAttribute("services");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ModuleDependencyType ElementName: xsd:boolean ElementType : optional
   // MaxOccurs: -  isGeneric: true   isAttribute: true isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>optional</code> attribute
    * @param optional the value for the attribute <code>optional</code> 
    * @return the current instance of <code>ModuleDependencyType<T></code> 
    */
   public ModuleDependencyType<T> optional(Boolean optional)
   {
      childNode.attribute("optional", optional);
      return this;
   }

   /**
    * Returns the <code>optional</code> attribute
    * @return the value defined for the attribute <code>optional</code> 
    */
   public Boolean isOptional()
   {
      return Strings.isTrue(childNode.getAttribute("optional"));
   }

   /**
    * Removes the <code>optional</code> attribute 
    * @return the current instance of <code>ModuleDependencyType<T></code> 
    */
   public ModuleDependencyType<T> removeOptional()
   {
      childNode.removeAttribute("optional");
      return this;
   }
}
