package org.jboss.shrinkwrap.descriptor.impl.jbossdeployment10; 

import org.jboss.shrinkwrap.descriptor.spi.node.Node;
import org.jboss.shrinkwrap.descriptor.api.jbossdeployment10.ModuleExclusionType;
import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Child;
import org.jboss.shrinkwrap.descriptor.impl.base.XMLDate;
import org.jboss.shrinkwrap.descriptor.impl.base.Strings;
import org.jboss.shrinkwrap.descriptor.api.DescriptorExporter;

/**
 * This class implements the <code> moduleExclusionType </code> xsd type 
 * @author <a href="mailto:ralf.battenfeld@bluewin.ch">Ralf Battenfeld</a>
 * @author <a href="mailto:alr@jboss.org">Andrew Lee Rubinger</a>
 */
public class ModuleExclusionTypeImpl<T> implements Child<T>, ModuleExclusionType<T>
{
   // -------------------------------------------------------------------------------------||
   // Instance Members 
   // -------------------------------------------------------------------------------------||

   private T t;
   private Node childNode;
   // -------------------------------------------------------------------------------------||
   // Constructor 
   // -------------------------------------------------------------------------------------||

   public ModuleExclusionTypeImpl(T t, String nodeName, Node node)   {
      this.t = t;
      this.childNode = node.createChild(nodeName);
   }

   public ModuleExclusionTypeImpl(T t, String nodeName, Node node, Node childNode)   {
      this.t = t;
      this.childNode = childNode;
   }


   public T up()
   {
      return t;
   }


 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ModuleExclusionType ElementName: xsd:string ElementType : name
   // MaxOccurs: -  isGeneric: true   isAttribute: true isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>name</code> attribute
    * @param name the value for the attribute <code>name</code> 
    * @return the current instance of <code>ModuleExclusionType<T></code> 
    */
   public ModuleExclusionType<T> name(String name)
   {
      childNode.attribute("name", name);
      return this;
   }

   /**
    * Returns the <code>name</code> attribute
    * @return the value defined for the attribute <code>name</code> 
    */
      public String getName()
   {
      return childNode.getAttribute("name");
   }

   /**
    * Removes the <code>name</code> attribute 
    * @return the current instance of <code>ModuleExclusionType<T></code> 
    */
   public ModuleExclusionType<T> removeName()
   {
      childNode.removeAttribute("name");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ModuleExclusionType ElementName: xsd:string ElementType : slot
   // MaxOccurs: -  isGeneric: true   isAttribute: true isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>slot</code> attribute
    * @param slot the value for the attribute <code>slot</code> 
    * @return the current instance of <code>ModuleExclusionType<T></code> 
    */
   public ModuleExclusionType<T> slot(String slot)
   {
      childNode.attribute("slot", slot);
      return this;
   }

   /**
    * Returns the <code>slot</code> attribute
    * @return the value defined for the attribute <code>slot</code> 
    */
      public String getSlot()
   {
      return childNode.getAttribute("slot");
   }

   /**
    * Removes the <code>slot</code> attribute 
    * @return the current instance of <code>ModuleExclusionType<T></code> 
    */
   public ModuleExclusionType<T> removeSlot()
   {
      childNode.removeAttribute("slot");
      return this;
   }
}
