package org.jboss.shrinkwrap.descriptor.impl.jbossmodule13; 

import org.jboss.shrinkwrap.descriptor.api.jbossmodule13.ModuleAliasDescriptor;
import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Child;
import org.jboss.shrinkwrap.descriptor.impl.base.XMLDate;
import org.jboss.shrinkwrap.descriptor.impl.base.Strings;
import org.jboss.shrinkwrap.descriptor.api.DescriptorExporter;
import java.util.Map.Entry;

import org.jboss.shrinkwrap.descriptor.api.DescriptorNamespace;

import org.jboss.shrinkwrap.descriptor.spi.node.NodeDescriptorImplBase;
import org.jboss.shrinkwrap.descriptor.impl.base.XMLDate;
import org.jboss.shrinkwrap.descriptor.spi.node.Node;

/** 
 * <p> 
 * This deployment descriptor provides the functionalities as described in the  specification
 * <p> 
 * Example:
 * <p> 
 * <code> 
 *     ModuleAliasDescriptor descriptor = Descriptors.create(ModuleAliasDescriptor.class);
 * </code> 
 *
 *
 * @author <a href="mailto:tcrawley@redhat.com">Toby Crawley</a>
 * @author <a href="mailto:alr@jboss.org">Andrew Lee Rubinger</a>
 */
public class ModuleAliasDescriptorImpl extends NodeDescriptorImplBase implements DescriptorNamespace<ModuleAliasDescriptor>, ModuleAliasDescriptor
{
   // -------------------------------------------------------------------------------------||
   // Instance Members 
   // -------------------------------------------------------------------------------------||

   private Node model;

   // -------------------------------------------------------------------------------------||
   // Constructor 
   // -------------------------------------------------------------------------------------||

   public ModuleAliasDescriptorImpl(String descriptorName)
   {
       this(descriptorName, new Node("module-alias"));
   }

   public ModuleAliasDescriptorImpl(String descriptorName, Node node)
   {
      super(descriptorName);
      this.model = node;
      addDefaultNamespaces();
   }

   // -------------------------------------------------------------------------------------||
   // Methods 
   // -------------------------------------------------------------------------------------||

   public Node getRootNode()
   {
      return model;
   }



   // -------------------------------------------------------------------------------------||
   // Namespace 
   // -------------------------------------------------------------------------------------||


   /**
    * Adds the default namespaces as defined in the specification 
    * @return the current instance of <code>ModuleAliasDescriptor</code> 
    */
   public ModuleAliasDescriptor addDefaultNamespaces()
   {
      addNamespace("xmlns", "urn:jboss:module:1.3");
     return this;
   }

   /**
    * Adds a new namespace 
    * @return the current instance of <code>ModuleAliasDescriptor</code> 
    */
   public ModuleAliasDescriptor addNamespace(String name, String value)
   {
      model.attribute(name, value);
      return this;
   }

   /**
    * Returns all defined namespaces. 
    * @return all defined namespaces 
    */
   public List<String> getNamespaces()
   {
      List<String> namespaceList = new ArrayList<String>();
      java.util.Map<String, String> attributes = model.getAttributes();
      for (Entry<String, String> e : attributes.entrySet())
      {
         final String name = e.getKey();
         final String value = e.getValue();
         if (value != null && value.startsWith("http://")) 
         {
            namespaceList.add(name + "=" + value);
         }
      }
      return namespaceList;
   }

   /**
    * Removes all existing namespaces. 
    * @return the current instance of <code>ModuleAliasDescriptor</code> 
    */
   public ModuleAliasDescriptor removeAllNamespaces()
   {
      List<String> nameSpaceKeys = new ArrayList<String>();
      java.util.Map<String, String> attributes = model.getAttributes();
      for (Entry<String, String> e : attributes.entrySet())
      {
         final String name = e.getKey();
         final String value = e.getValue();
         if (value != null && value.startsWith("http://")) 
         {
            nameSpaceKeys.add(name);
         }
      }
      for (String name: nameSpaceKeys)
      {
         model.removeAttribute(name);
      }
      return this;
   }
 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ModuleAliasDescriptor ElementName: xsd:string ElementType : name
   // MaxOccurs: -  isGeneric: false   isAttribute: true isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>name</code> attribute
    * @param name the value for the attribute <code>name</code> 
    * @return the current instance of <code>ModuleAliasDescriptor</code> 
    */
   public ModuleAliasDescriptor name(String name)
   {
      model.attribute("name", name);
      return this;
   }

   /**
    * Returns the <code>name</code> attribute
    * @return the value defined for the attribute <code>name</code> 
    */
      public String getName()
   {
      return model.getAttribute("name");
   }

   /**
    * Removes the <code>name</code> attribute 
    * @return the current instance of <code>ModuleAliasDescriptor</code> 
    */
   public ModuleAliasDescriptor removeName()
   {
      model.removeAttribute("name");
      return this;
   }
 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ModuleAliasDescriptor ElementName: xsd:string ElementType : slot
   // MaxOccurs: -  isGeneric: false   isAttribute: true isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>slot</code> attribute
    * @param slot the value for the attribute <code>slot</code> 
    * @return the current instance of <code>ModuleAliasDescriptor</code> 
    */
   public ModuleAliasDescriptor slot(String slot)
   {
      model.attribute("slot", slot);
      return this;
   }

   /**
    * Returns the <code>slot</code> attribute
    * @return the value defined for the attribute <code>slot</code> 
    */
      public String getSlot()
   {
      return model.getAttribute("slot");
   }

   /**
    * Removes the <code>slot</code> attribute 
    * @return the current instance of <code>ModuleAliasDescriptor</code> 
    */
   public ModuleAliasDescriptor removeSlot()
   {
      model.removeAttribute("slot");
      return this;
   }
 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ModuleAliasDescriptor ElementName: xsd:string ElementType : target-name
   // MaxOccurs: -  isGeneric: false   isAttribute: true isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>target-name</code> attribute
    * @param targetName the value for the attribute <code>target-name</code> 
    * @return the current instance of <code>ModuleAliasDescriptor</code> 
    */
   public ModuleAliasDescriptor targetName(String targetName)
   {
      model.attribute("target-name", targetName);
      return this;
   }

   /**
    * Returns the <code>target-name</code> attribute
    * @return the value defined for the attribute <code>target-name</code> 
    */
      public String getTargetName()
   {
      return model.getAttribute("target-name");
   }

   /**
    * Removes the <code>target-name</code> attribute 
    * @return the current instance of <code>ModuleAliasDescriptor</code> 
    */
   public ModuleAliasDescriptor removeTargetName()
   {
      model.removeAttribute("target-name");
      return this;
   }
 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ModuleAliasDescriptor ElementName: xsd:string ElementType : target-slot
   // MaxOccurs: -  isGeneric: false   isAttribute: true isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>target-slot</code> attribute
    * @param targetSlot the value for the attribute <code>target-slot</code> 
    * @return the current instance of <code>ModuleAliasDescriptor</code> 
    */
   public ModuleAliasDescriptor targetSlot(String targetSlot)
   {
      model.attribute("target-slot", targetSlot);
      return this;
   }

   /**
    * Returns the <code>target-slot</code> attribute
    * @return the value defined for the attribute <code>target-slot</code> 
    */
      public String getTargetSlot()
   {
      return model.getAttribute("target-slot");
   }

   /**
    * Removes the <code>target-slot</code> attribute 
    * @return the current instance of <code>ModuleAliasDescriptor</code> 
    */
   public ModuleAliasDescriptor removeTargetSlot()
   {
      model.removeAttribute("target-slot");
      return this;
   }

}
