package org.jboss.shrinkwrap.descriptor.impl.jbossmodule13; 

import org.jboss.shrinkwrap.descriptor.spi.node.Node;
import org.jboss.shrinkwrap.descriptor.api.jbossmodule13.PermissionType;
import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Child;
import org.jboss.shrinkwrap.descriptor.impl.base.XMLDate;
import org.jboss.shrinkwrap.descriptor.impl.base.Strings;
import org.jboss.shrinkwrap.descriptor.api.DescriptorExporter;

/**
 * This class implements the <code> permissionType </code> xsd type 
 * @author <a href="mailto:tcrawley@redhat.com">Toby Crawley</a>
 * @author <a href="mailto:alr@jboss.org">Andrew Lee Rubinger</a>
 */
public class PermissionTypeImpl<T> implements Child<T>, PermissionType<T>
{
   // -------------------------------------------------------------------------------------||
   // Instance Members 
   // -------------------------------------------------------------------------------------||

   private T t;
   private Node childNode;
   // -------------------------------------------------------------------------------------||
   // Constructor 
   // -------------------------------------------------------------------------------------||

   public PermissionTypeImpl(T t, String nodeName, Node node)   {
      this.t = t;
      this.childNode = node.createChild(nodeName);
   }

   public PermissionTypeImpl(T t, String nodeName, Node node, Node childNode)   {
      this.t = t;
      this.childNode = childNode;
   }


   public T up()
   {
      return t;
   }


 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: PermissionType ElementName: xsd:string ElementType : permission
   // MaxOccurs: -  isGeneric: true   isAttribute: true isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>permission</code> attribute
    * @param permission the value for the attribute <code>permission</code> 
    * @return the current instance of <code>PermissionType<T></code> 
    */
   public PermissionType<T> permission(String permission)
   {
      childNode.attribute("permission", permission);
      return this;
   }

   /**
    * Returns the <code>permission</code> attribute
    * @return the value defined for the attribute <code>permission</code> 
    */
      public String getPermission()
   {
      return childNode.getAttribute("permission");
   }

   /**
    * Removes the <code>permission</code> attribute 
    * @return the current instance of <code>PermissionType<T></code> 
    */
   public PermissionType<T> removePermission()
   {
      childNode.removeAttribute("permission");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: PermissionType ElementName: xsd:string ElementType : name
   // MaxOccurs: -  isGeneric: true   isAttribute: true isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>name</code> attribute
    * @param name the value for the attribute <code>name</code> 
    * @return the current instance of <code>PermissionType<T></code> 
    */
   public PermissionType<T> name(String name)
   {
      childNode.attribute("name", name);
      return this;
   }

   /**
    * Returns the <code>name</code> attribute
    * @return the value defined for the attribute <code>name</code> 
    */
      public String getName()
   {
      return childNode.getAttribute("name");
   }

   /**
    * Removes the <code>name</code> attribute 
    * @return the current instance of <code>PermissionType<T></code> 
    */
   public PermissionType<T> removeName()
   {
      childNode.removeAttribute("name");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: PermissionType ElementName: xsd:string ElementType : actions
   // MaxOccurs: -  isGeneric: true   isAttribute: true isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>actions</code> attribute
    * @param actions the value for the attribute <code>actions</code> 
    * @return the current instance of <code>PermissionType<T></code> 
    */
   public PermissionType<T> actions(String actions)
   {
      childNode.attribute("actions", actions);
      return this;
   }

   /**
    * Returns the <code>actions</code> attribute
    * @return the value defined for the attribute <code>actions</code> 
    */
      public String getActions()
   {
      return childNode.getAttribute("actions");
   }

   /**
    * Removes the <code>actions</code> attribute 
    * @return the current instance of <code>PermissionType<T></code> 
    */
   public PermissionType<T> removeActions()
   {
      childNode.removeAttribute("actions");
      return this;
   }
}
