package org.jboss.shrinkwrap.descriptor.impl.wildflyfeaturepack11; 

import org.jboss.shrinkwrap.descriptor.spi.node.Node;
import org.jboss.shrinkwrap.descriptor.api.wildflyfeaturepack11.ArtifactType;
import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Child;
import org.jboss.shrinkwrap.descriptor.impl.base.XMLDate;
import org.jboss.shrinkwrap.descriptor.impl.base.Strings;
import org.jboss.shrinkwrap.descriptor.api.DescriptorExporter;

/**
 * This class implements the <code> artifact-type </code> xsd type 
 * @author <a href="mailto:bmcwhirt@redhat.com">Bob McWhirter</a>
 * @author <a href="mailto:alr@jboss.org">Andrew Lee Rubinger</a>
 */
public class ArtifactTypeImpl<T> implements Child<T>, ArtifactType<T>
{
   // -------------------------------------------------------------------------------------||
   // Instance Members 
   // -------------------------------------------------------------------------------------||

   private T t;
   private Node childNode;
   // -------------------------------------------------------------------------------------||
   // Constructor 
   // -------------------------------------------------------------------------------------||

   public ArtifactTypeImpl(T t, String nodeName, Node node)   {
      this.t = t;
      this.childNode = node.createChild(nodeName);
   }

   public ArtifactTypeImpl(T t, String nodeName, Node node, Node childNode)   {
      this.t = t;
      this.childNode = childNode;
   }


   public T up()
   {
      return t;
   }


 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ArtifactType ElementName: xsd:string ElementType : groupId
   // MaxOccurs: -  isGeneric: true   isAttribute: true isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>groupId</code> attribute
    * @param groupId the value for the attribute <code>groupId</code> 
    * @return the current instance of <code>ArtifactType<T></code> 
    */
   public ArtifactType<T> groupId(String groupId)
   {
      childNode.attribute("groupId", groupId);
      return this;
   }

   /**
    * Returns the <code>groupId</code> attribute
    * @return the value defined for the attribute <code>groupId</code> 
    */
      public String getGroupId()
   {
      return childNode.getAttribute("groupId");
   }

   /**
    * Removes the <code>groupId</code> attribute 
    * @return the current instance of <code>ArtifactType<T></code> 
    */
   public ArtifactType<T> removeGroupId()
   {
      childNode.removeAttribute("groupId");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ArtifactType ElementName: xsd:string ElementType : artifactId
   // MaxOccurs: -  isGeneric: true   isAttribute: true isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>artifactId</code> attribute
    * @param artifactId the value for the attribute <code>artifactId</code> 
    * @return the current instance of <code>ArtifactType<T></code> 
    */
   public ArtifactType<T> artifactId(String artifactId)
   {
      childNode.attribute("artifactId", artifactId);
      return this;
   }

   /**
    * Returns the <code>artifactId</code> attribute
    * @return the value defined for the attribute <code>artifactId</code> 
    */
      public String getArtifactId()
   {
      return childNode.getAttribute("artifactId");
   }

   /**
    * Removes the <code>artifactId</code> attribute 
    * @return the current instance of <code>ArtifactType<T></code> 
    */
   public ArtifactType<T> removeArtifactId()
   {
      childNode.removeAttribute("artifactId");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ArtifactType ElementName: xsd:string ElementType : classifier
   // MaxOccurs: -  isGeneric: true   isAttribute: true isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>classifier</code> attribute
    * @param classifier the value for the attribute <code>classifier</code> 
    * @return the current instance of <code>ArtifactType<T></code> 
    */
   public ArtifactType<T> classifier(String classifier)
   {
      childNode.attribute("classifier", classifier);
      return this;
   }

   /**
    * Returns the <code>classifier</code> attribute
    * @return the value defined for the attribute <code>classifier</code> 
    */
      public String getClassifier()
   {
      return childNode.getAttribute("classifier");
   }

   /**
    * Removes the <code>classifier</code> attribute 
    * @return the current instance of <code>ArtifactType<T></code> 
    */
   public ArtifactType<T> removeClassifier()
   {
      childNode.removeAttribute("classifier");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ArtifactType ElementName: xsd:string ElementType : extension
   // MaxOccurs: -  isGeneric: true   isAttribute: true isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>extension</code> attribute
    * @param extension the value for the attribute <code>extension</code> 
    * @return the current instance of <code>ArtifactType<T></code> 
    */
   public ArtifactType<T> extension(String extension)
   {
      childNode.attribute("extension", extension);
      return this;
   }

   /**
    * Returns the <code>extension</code> attribute
    * @return the value defined for the attribute <code>extension</code> 
    */
      public String getExtension()
   {
      return childNode.getAttribute("extension");
   }

   /**
    * Removes the <code>extension</code> attribute 
    * @return the current instance of <code>ArtifactType<T></code> 
    */
   public ArtifactType<T> removeExtension()
   {
      childNode.removeAttribute("extension");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ArtifactType ElementName: xsd:string ElementType : version
   // MaxOccurs: -  isGeneric: true   isAttribute: true isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>version</code> attribute
    * @param version the value for the attribute <code>version</code> 
    * @return the current instance of <code>ArtifactType<T></code> 
    */
   public ArtifactType<T> version(String version)
   {
      childNode.attribute("version", version);
      return this;
   }

   /**
    * Returns the <code>version</code> attribute
    * @return the value defined for the attribute <code>version</code> 
    */
      public String getVersion()
   {
      return childNode.getAttribute("version");
   }

   /**
    * Removes the <code>version</code> attribute 
    * @return the current instance of <code>ArtifactType<T></code> 
    */
   public ArtifactType<T> removeVersion()
   {
      childNode.removeAttribute("version");
      return this;
   }
}
