/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.servicenow;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.ComponentVerifier;
import org.apache.camel.Endpoint;
import org.apache.camel.SSLContextParametersAware;
import org.apache.camel.VerifiableComponent;
import org.apache.camel.component.servicenow.ServiceNowComponentVerifier;
import org.apache.camel.component.servicenow.ServiceNowConfiguration;
import org.apache.camel.component.servicenow.ServiceNowEndpoint;
import org.apache.camel.impl.UriEndpointComponent;
import org.apache.camel.spi.Metadata;
import org.apache.camel.util.EndpointHelper;
import org.apache.camel.util.IntrospectionSupport;

@Metadata(label="verifiers", enums="parameters,connectivity")
public class ServiceNowComponent
extends UriEndpointComponent
implements VerifiableComponent,
SSLContextParametersAware {
    @Metadata(label="advanced")
    private ServiceNowConfiguration configuration = new ServiceNowConfiguration();
    @Metadata(label="security", defaultValue="false")
    private boolean useGlobalSslContextParameters;

    public ServiceNowComponent() {
        super(ServiceNowEndpoint.class);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        CamelContext context = this.getCamelContext();
        ServiceNowConfiguration configuration = this.configuration.copy();
        Map models = IntrospectionSupport.extractProperties(parameters, (String)"model.");
        for (Map.Entry entry : models.entrySet()) {
            configuration.addModel((String)entry.getKey(), (Class)EndpointHelper.resolveParameter((CamelContext)context, (String)((String)entry.getValue()), Class.class));
        }
        Map requestModels = IntrospectionSupport.extractProperties(parameters, (String)"requestModel.");
        for (Map.Entry entry : requestModels.entrySet()) {
            configuration.addRequestModel((String)entry.getKey(), (Class)EndpointHelper.resolveParameter((CamelContext)context, (String)((String)entry.getValue()), Class.class));
        }
        Map map = IntrospectionSupport.extractProperties(parameters, (String)"responseModel.");
        for (Map.Entry entry : map.entrySet()) {
            configuration.addResponseModel((String)entry.getKey(), (Class)EndpointHelper.resolveParameter((CamelContext)context, (String)((String)entry.getValue()), Class.class));
        }
        this.setProperties(configuration, parameters);
        String string = this.getCamelContext().resolvePropertyPlaceholders(remaining);
        if (!configuration.hasApiUrl()) {
            configuration.setApiUrl(String.format("https://%s.service-now.com/api", string));
        }
        if (!configuration.hasOauthTokenUrl()) {
            configuration.setOauthTokenUrl(String.format("https://%s.service-now.com/oauth_token.do", string));
        }
        if (configuration.getSslContextParameters() == null) {
            configuration.setSslContextParameters(this.retrieveGlobalSslContextParameters());
        }
        return new ServiceNowEndpoint(uri, this, configuration, string);
    }

    public ServiceNowConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(ServiceNowConfiguration configuration) {
        this.configuration = configuration;
    }

    public String getApiUrl() {
        return this.configuration.getApiUrl();
    }

    public void setApiUrl(String apiUrl) {
        this.configuration.setApiUrl(apiUrl);
    }

    public String getUserName() {
        return this.configuration.getUserName();
    }

    @Metadata(label="security", secret=true)
    public void setUserName(String userName) {
        this.configuration.setUserName(userName);
    }

    public String getPassword() {
        return this.configuration.getPassword();
    }

    @Metadata(label="security", secret=true)
    public void setPassword(String password) {
        this.configuration.setPassword(password);
    }

    public String getOauthClientId() {
        return this.configuration.getOauthClientId();
    }

    @Metadata(label="security", secret=true)
    public void setOauthClientId(String oauthClientId) {
        this.configuration.setOauthClientId(oauthClientId);
    }

    public String getOauthClientSecret() {
        return this.configuration.getOauthClientSecret();
    }

    @Metadata(label="security", secret=true)
    public void setOauthClientSecret(String oauthClientSecret) {
        this.configuration.setOauthClientSecret(oauthClientSecret);
    }

    public String getOauthTokenUrl() {
        return this.configuration.getOauthTokenUrl();
    }

    @Metadata(label="security", secret=true)
    public void setOauthTokenUrl(String oauthTokenUrl) {
        this.configuration.setOauthTokenUrl(oauthTokenUrl);
    }

    public boolean isUseGlobalSslContextParameters() {
        return this.useGlobalSslContextParameters;
    }

    public void setUseGlobalSslContextParameters(boolean useGlobalSslContextParameters) {
        this.useGlobalSslContextParameters = useGlobalSslContextParameters;
    }

    public ComponentVerifier getVerifier() {
        return new ServiceNowComponentVerifier(this);
    }
}

