/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.spring.integration.adapter.config;

import org.apache.camel.util.ObjectHelper;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AbstractCamelContextBeanDefinitionParaser
extends AbstractSingleBeanDefinitionParser {
    private static final String DEFAULT_CAMEL_CONTEXT_NAME = "camelContext";

    private String getContextId(String contextId) {
        if (ObjectHelper.isEmpty((Object)contextId)) {
            return DEFAULT_CAMEL_CONTEXT_NAME;
        }
        return contextId;
    }

    protected void mapToProperty(BeanDefinitionBuilder bean, String propertyName, String val) {
        if ("id".equals(propertyName)) {
            return;
        }
        if (StringUtils.hasText((String)val)) {
            if (val.startsWith("#")) {
                bean.addPropertyReference(propertyName, val.substring(1));
            } else {
                bean.addPropertyValue(propertyName, (Object)val);
            }
        }
    }

    protected void wireCamelContext(BeanDefinitionBuilder bean, String camelContextId) {
        bean.addPropertyReference(DEFAULT_CAMEL_CONTEXT_NAME, camelContextId);
    }

    protected void parseAttributes(Element element, ParserContext ctx, BeanDefinitionBuilder bean) {
        NamedNodeMap atts = element.getAttributes();
        for (int i = 0; i < atts.getLength(); ++i) {
            Attr node = (Attr)atts.item(i);
            String val = node.getValue();
            String name = node.getLocalName();
            if (name.equals("requestChannel") || name.equals("replyChannel")) {
                bean.addPropertyReference(name, val);
                continue;
            }
            this.mapToProperty(bean, name, val);
        }
    }

    protected void parseCamelContext(Element element, ParserContext ctx, BeanDefinitionBuilder bean) {
        NodeList children = element.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node n = children.item(i);
            if (n.getNodeType() != 1) continue;
            String name = n.getLocalName();
            if (DEFAULT_CAMEL_CONTEXT_NAME.equals(name)) {
                BeanDefinition bd = ctx.getDelegate().parseCustomElement((Element)n);
                String contextId = (String)bd.getPropertyValues().getPropertyValue("id").getValue();
                this.wireCamelContext(bean, this.getContextId(contextId));
                continue;
            }
            if (!"camelContextRef".equals(name)) continue;
            String contextId = n.getTextContent();
            this.wireCamelContext(bean, this.getContextId(contextId));
        }
    }

    protected void doParse(Element element, ParserContext ctx, BeanDefinitionBuilder bean) {
        this.parseAttributes(element, ctx, bean);
        this.parseCamelContext(element, ctx, bean);
    }
}

