/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.dropbox.validator;

import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.camel.component.dropbox.DropboxConfiguration;
import org.apache.camel.component.dropbox.util.DropboxException;
import org.apache.camel.component.dropbox.util.DropboxOperation;

public final class DropboxConfigurationValidator {
    private static final Pattern PATTERN = Pattern.compile("/*?(\\S+)/*?", 2);

    private DropboxConfigurationValidator() {
    }

    public static void validate(DropboxConfiguration configuration) throws DropboxException {
        DropboxConfigurationValidator.validateCommonProperties(configuration);
        DropboxOperation op = configuration.getOperation();
        if (op == DropboxOperation.get) {
            DropboxConfigurationValidator.validateGetOp(configuration);
        } else if (op == DropboxOperation.put) {
            DropboxConfigurationValidator.validatePutOp(configuration);
        } else if (op == DropboxOperation.search) {
            DropboxConfigurationValidator.validateSearchOp(configuration);
        } else if (op == DropboxOperation.del) {
            DropboxConfigurationValidator.validateDelOp(configuration);
        } else if (op == DropboxOperation.move) {
            DropboxConfigurationValidator.validateMoveOp(configuration);
        }
    }

    private static void validateCommonProperties(DropboxConfiguration configuration) throws DropboxException {
        if (configuration.getAccessToken() == null || configuration.getAccessToken().equals("")) {
            throw new DropboxException("option <accessToken> is not present or not valid!");
        }
        if (configuration.getClientIdentifier() == null || configuration.getClientIdentifier().equals("")) {
            throw new DropboxException("option <clientIdentifier> is not present or not valid!");
        }
    }

    private static void validateGetOp(DropboxConfiguration configuration) throws DropboxException {
        DropboxConfigurationValidator.validateRemotePath(configuration.getRemotePath());
    }

    private static void validatePutOp(DropboxConfiguration configuration) throws DropboxException {
        DropboxConfigurationValidator.validateLocalPath(configuration.getLocalPath());
        if (configuration.getRemotePath() != null) {
            DropboxConfigurationValidator.validateRemotePathForPut(configuration.getRemotePath());
        } else {
            DropboxConfigurationValidator.validatePathInUnix(configuration.getLocalPath());
        }
        if (configuration.getUploadMode() == null) {
            throw new DropboxException("option <uploadMode> is not present or not valid!");
        }
    }

    private static void validateSearchOp(DropboxConfiguration configuration) throws DropboxException {
        DropboxConfigurationValidator.validateRemotePath(configuration.getRemotePath());
    }

    private static void validateDelOp(DropboxConfiguration configuration) throws DropboxException {
        DropboxConfigurationValidator.validateRemotePath(configuration.getRemotePath());
    }

    private static void validateMoveOp(DropboxConfiguration configuration) throws DropboxException {
        DropboxConfigurationValidator.validateRemotePath(configuration.getRemotePath());
        DropboxConfigurationValidator.validateRemotePath(configuration.getNewRemotePath());
    }

    private static void validateLocalPath(String localPath) throws DropboxException {
        if (localPath == null || localPath.equals("")) {
            throw new DropboxException("option <localPath> is not present or not valid!");
        }
        File file = new File(localPath);
        if (!file.exists()) {
            throw new DropboxException("option <localPath> is not an existing file or directory!");
        }
    }

    private static void validateRemotePath(String remotePath) throws DropboxException {
        if (remotePath == null || !remotePath.startsWith("/")) {
            throw new DropboxException("option <remotePath> is not valid!");
        }
        DropboxConfigurationValidator.validatePathInUnix(remotePath);
    }

    private static void validateRemotePathForPut(String remotePath) throws DropboxException {
        if (!remotePath.startsWith("/")) {
            throw new DropboxException("option <remotePath> is not valid!");
        }
        DropboxConfigurationValidator.validatePathInUnix(remotePath);
    }

    private static void validatePathInUnix(String path) throws DropboxException {
        Matcher matcher = PATTERN.matcher(path);
        if (!matcher.matches()) {
            throw new DropboxException(path + " is not a valid path, must be in UNIX form!");
        }
    }
}

