/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.datasources.data_source;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.HashMap;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;

@Address(value="/subsystem=datasources/data-source=*/connection-properties=*")
@ResourceType(value="connection-properties")
public class ConnectionProperties<T extends ConnectionProperties<T>>
extends HashMap
implements Keyed {
    private String key;
    private PropertyChangeSupport pcs;
    @AttributeDocumentation(value="Each connection-property specifies a string name/value pair with the property name coming from the name attribute and the value coming from the element content")
    private String value;

    public ConnectionProperties(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    @ModelNodeBinding(detypedName="value")
    public String value() {
        return this.value;
    }

    public T value(String value) {
        String oldValue = this.value;
        this.value = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("value", oldValue, value);
        }
        return (T)this;
    }
}

