/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.ejb3;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.HashMap;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;

@Address(value="/subsystem=ejb3/cluster-passivation-store=*")
@ResourceType(value="cluster-passivation-store")
public class ClusterPassivationStore<T extends ClusterPassivationStore<T>>
extends HashMap
implements Keyed {
    private String key;
    private PropertyChangeSupport pcs;
    @AttributeDocumentation(value="The name of the cache used to store bean instances.")
    private String beanCache;
    @AttributeDocumentation(value="The name of the cache container used for the bean and client-mappings caches")
    private String cacheContainer;
    @AttributeDocumentation(value="The timeout in units specified by idle-timeout-unit, after which a bean will passivate")
    private Long idleTimeout;
    @AttributeDocumentation(value="The maximum number of beans this cache should store before forcing old beans to passivate")
    private Integer maxSize;

    public ClusterPassivationStore(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    @ModelNodeBinding(detypedName="bean-cache")
    public String beanCache() {
        return this.beanCache;
    }

    public T beanCache(String value) {
        String oldValue = this.beanCache;
        this.beanCache = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("beanCache", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="cache-container")
    public String cacheContainer() {
        return this.cacheContainer;
    }

    public T cacheContainer(String value) {
        String oldValue = this.cacheContainer;
        this.cacheContainer = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("cacheContainer", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="idle-timeout")
    public Long idleTimeout() {
        return this.idleTimeout;
    }

    public T idleTimeout(Long value) {
        Long oldValue = this.idleTimeout;
        this.idleTimeout = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("idleTimeout", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="max-size")
    public Integer maxSize() {
        return this.maxSize;
    }

    public T maxSize(Integer value) {
        Integer oldValue = this.maxSize;
        this.maxSize = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("maxSize", oldValue, value);
        }
        return (T)this;
    }
}

