/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.undertow;

import io.undertow.client.ClientCallback;
import io.undertow.client.ClientConnection;
import io.undertow.client.ClientExchange;
import io.undertow.client.ClientRequest;
import io.undertow.client.ClientResponse;
import io.undertow.client.UndertowClient;
import io.undertow.connector.ByteBufferPool;
import io.undertow.server.DefaultByteBufferPool;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import io.undertow.util.Methods;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.camel.ComponentVerifier;
import org.apache.camel.component.undertow.UndertowComponent;
import org.apache.camel.impl.verifier.DefaultComponentVerifier;
import org.apache.camel.impl.verifier.ResultBuilder;
import org.apache.camel.impl.verifier.ResultErrorBuilder;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.URISupport;
import org.apache.camel.util.UnsafeUriCharactersEncoder;
import org.xnio.AbstractIoFuture;
import org.xnio.IoFuture;
import org.xnio.OptionMap;
import org.xnio.Xnio;
import org.xnio.XnioWorker;

public final class UndertowComponentVerifier
extends DefaultComponentVerifier {
    private final UndertowComponent component;

    public UndertowComponentVerifier(UndertowComponent component) {
        super("undertow", component.getCamelContext());
        this.component = component;
    }

    protected ComponentVerifier.Result verifyParameters(Map<String, Object> parameters) {
        ResultBuilder builder = ResultBuilder.withStatusAndScope((ComponentVerifier.Result.Status)ComponentVerifier.Result.Status.OK, (ComponentVerifier.Scope)ComponentVerifier.Scope.PARAMETERS);
        HashMap<String, Object> verifyParams = new HashMap<String, Object>(parameters);
        boolean isRest = verifyParams.entrySet().stream().anyMatch(e -> ((String)e.getKey()).startsWith("rest."));
        if (isRest) {
            String httpUri = this.getOption(verifyParams, "rest.host", String.class).orElse(null);
            String path = this.getOption(verifyParams, "rest.path", String.class).map(FileUtil::stripLeadingSeparator).orElse(null);
            if (ObjectHelper.isNotEmpty((Object)httpUri) && ObjectHelper.isNotEmpty((Object)path)) {
                httpUri = httpUri + "/" + path;
            }
            verifyParams.put("httpURI", httpUri);
            verifyParams.entrySet().removeIf(e -> ((String)e.getKey()).startsWith("rest."));
        }
        super.verifyParametersAgainstCatalog(builder, verifyParams);
        return builder.build();
    }

    protected ComponentVerifier.Result verifyConnectivity(Map<String, Object> parameters) {
        Optional httpMethod;
        String httpUri;
        ResultBuilder builder = ResultBuilder.withStatusAndScope((ComponentVerifier.Result.Status)ComponentVerifier.Result.Status.OK, (ComponentVerifier.Scope)ComponentVerifier.Scope.CONNECTIVITY);
        HashMap<String, Object> verifyParams = new HashMap<String, Object>(parameters);
        boolean isRest = verifyParams.entrySet().stream().anyMatch(e -> ((String)e.getKey()).startsWith("rest."));
        if (isRest) {
            httpUri = this.getOption(verifyParams, "rest.host", String.class).orElse(null);
            httpMethod = this.getOption(verifyParams, "rest.method", String.class);
            String path = this.getOption(verifyParams, "rest.path", String.class).map(FileUtil::stripLeadingSeparator).orElse(null);
            if (ObjectHelper.isNotEmpty((Object)httpUri) && ObjectHelper.isNotEmpty((Object)path)) {
                httpUri = httpUri + "/" + path;
            }
            verifyParams.put("httpURI", httpUri);
            verifyParams.entrySet().removeIf(e -> ((String)e.getKey()).startsWith("rest."));
        }
        httpUri = this.getOption(verifyParams, "httpURI", String.class).orElse(null);
        httpMethod = Optional.empty();
        if (ObjectHelper.isEmpty((Object)httpUri)) {
            builder.error(ResultErrorBuilder.withMissingOption((String)"httpURI").detail("rest", (Object)isRest).build());
            return builder.build();
        }
        try {
            UndertowClientWrapper wrapper = new UndertowClientWrapper();
            ClientResponse response = wrapper.send(httpUri, httpMethod);
            if (response != null) {
                int code = response.getResponseCode();
                if (code == 401) {
                    builder.error(ResultErrorBuilder.withHttpCode((int)code).description(response.getStatus()).build());
                } else if (code >= 300 && code < 400) {
                    builder.error(ResultErrorBuilder.withHttpCode((int)code).description(response.getStatus()).parameterKey("httpURI").detail((ComponentVerifier.VerificationError.Attribute)ComponentVerifier.VerificationError.HttpAttribute.HTTP_REDIRECT, () -> Optional.ofNullable(response.getResponseHeaders().get(Headers.LOCATION).getFirst())).build());
                } else if (code >= 400) {
                    builder.error(ResultErrorBuilder.withHttpCode((int)code).description(response.getStatus()).build());
                }
            }
        }
        catch (Exception e2) {
            builder.error(ResultErrorBuilder.withException((Exception)e2).build());
        }
        return builder.build();
    }

    private static final class UndertowClientResponseFuture
    extends AbstractIoFuture<ClientExchange>
    implements ClientCallback<ClientExchange> {
        private UndertowClientResponseFuture() {
        }

        public void completed(ClientExchange result) {
            result.setResponseListener((ClientCallback)new ClientCallback<ClientExchange>(){

                public void completed(ClientExchange result) {
                    this.setResult(result);
                }

                public void failed(IOException e) {
                    this.setException(e);
                }
            });
        }

        public void failed(IOException e) {
            this.setException(e);
        }
    }

    private final class UndertowClientWrapper {
        private final XnioWorker worker = Xnio.getInstance().createWorker(OptionMap.EMPTY);
        private final ByteBufferPool pool = new DefaultByteBufferPool(true, 17408);
        private UndertowClient client;

        private UndertowClientWrapper() throws IOException, URISyntaxException {
            this.client = UndertowClient.getInstance((ClassLoader)UndertowComponentVerifier.this.getCamelContext().getApplicationContextClassLoader());
        }

        public ClientResponse send(String httpUri, Optional<String> httpMethod) throws Exception {
            URI uri = new URI(UnsafeUriCharactersEncoder.encodeHttpURI((String)httpUri));
            HttpString method = httpMethod.map(Methods::fromString).orElse(Methods.GET);
            ClientRequest request = new ClientRequest();
            request.setMethod(method);
            request.setPath(URISupport.pathAndQueryOf((URI)uri));
            IoFuture connectFuture = this.client.connect(uri, this.worker, this.pool, OptionMap.EMPTY);
            UndertowClientResponseFuture responseFuture = new UndertowClientResponseFuture();
            ((ClientConnection)connectFuture.get()).sendRequest(request, (ClientCallback)responseFuture);
            return ((ClientExchange)responseFuture.get()).getResponse();
        }
    }
}

