/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.ddb;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.component.aws.ddb.DdbConfiguration;
import org.apache.camel.component.aws.ddb.DdbEndpoint;
import org.apache.camel.impl.UriEndpointComponent;

public class DdbComponent
extends UriEndpointComponent {
    public DdbComponent() {
        super(DdbEndpoint.class);
    }

    public DdbComponent(CamelContext context) {
        super(context, DdbEndpoint.class);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        DdbConfiguration configuration = new DdbConfiguration();
        this.setProperties(configuration, parameters);
        if (remaining == null || remaining.trim().length() == 0) {
            throw new IllegalArgumentException("Table name must be specified.");
        }
        configuration.setTableName(remaining);
        if (configuration.getAmazonDDBClient() == null) {
            throw new IllegalArgumentException("amazonDDBClient must be specified");
        }
        DdbEndpoint endpoint = new DdbEndpoint(uri, (Component)this, configuration);
        return endpoint;
    }
}

