package org.jboss.shrinkwrap.descriptor.api.jbossmodule13; 

import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Child;
import org.jboss.shrinkwrap.descriptor.api.Descriptor;
import org.jboss.shrinkwrap.descriptor.api.DescriptorNamespace;

/** 
 * <p> 
 * This deployment descriptor provides the functionalities as described in the  specification
 * <p> 
 * Example:
 * <p> 
 * <code> 
 *     ModuleAliasDescriptor descriptor = Descriptors.create(ModuleAliasDescriptor.class);
 * </code> 
 *
 *
 * @author <a href="mailto:tcrawley@redhat.com">Toby Crawley</a>
 * @author <a href="mailto:alr@jboss.org">Andrew Lee Rubinger</a>
 */
public interface ModuleAliasDescriptor extends Descriptor, DescriptorNamespace<ModuleAliasDescriptor> {

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ModuleAliasDescriptor ElementName: xsd:string ElementType : name
   // MaxOccurs: -  isGeneric: false   isAttribute: true isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>name</code> attribute
    * @param name the value for the attribute <code>name</code> 
    * @return the current instance of <code>ModuleAliasDescriptor</code> 
    */
   public ModuleAliasDescriptor name(String name);

   /**
    * Returns the <code>name</code> attribute
    * @return the value defined for the attribute <code>name</code> 
    */
   public String getName();

   /**
    * Removes the <code>name</code> attribute 
    * @return the current instance of <code>ModuleAliasDescriptor</code> 
    */
   public ModuleAliasDescriptor removeName();
 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ModuleAliasDescriptor ElementName: xsd:string ElementType : slot
   // MaxOccurs: -  isGeneric: false   isAttribute: true isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>slot</code> attribute
    * @param slot the value for the attribute <code>slot</code> 
    * @return the current instance of <code>ModuleAliasDescriptor</code> 
    */
   public ModuleAliasDescriptor slot(String slot);

   /**
    * Returns the <code>slot</code> attribute
    * @return the value defined for the attribute <code>slot</code> 
    */
   public String getSlot();

   /**
    * Removes the <code>slot</code> attribute 
    * @return the current instance of <code>ModuleAliasDescriptor</code> 
    */
   public ModuleAliasDescriptor removeSlot();
 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ModuleAliasDescriptor ElementName: xsd:string ElementType : target-name
   // MaxOccurs: -  isGeneric: false   isAttribute: true isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>target-name</code> attribute
    * @param targetName the value for the attribute <code>target-name</code> 
    * @return the current instance of <code>ModuleAliasDescriptor</code> 
    */
   public ModuleAliasDescriptor targetName(String targetName);

   /**
    * Returns the <code>target-name</code> attribute
    * @return the value defined for the attribute <code>target-name</code> 
    */
   public String getTargetName();

   /**
    * Removes the <code>target-name</code> attribute 
    * @return the current instance of <code>ModuleAliasDescriptor</code> 
    */
   public ModuleAliasDescriptor removeTargetName();
 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ModuleAliasDescriptor ElementName: xsd:string ElementType : target-slot
   // MaxOccurs: -  isGeneric: false   isAttribute: true isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>target-slot</code> attribute
    * @param targetSlot the value for the attribute <code>target-slot</code> 
    * @return the current instance of <code>ModuleAliasDescriptor</code> 
    */
   public ModuleAliasDescriptor targetSlot(String targetSlot);

   /**
    * Returns the <code>target-slot</code> attribute
    * @return the value defined for the attribute <code>target-slot</code> 
    */
   public String getTargetSlot();

   /**
    * Removes the <code>target-slot</code> attribute 
    * @return the current instance of <code>ModuleAliasDescriptor</code> 
    */
   public ModuleAliasDescriptor removeTargetSlot();
}
