package org.jboss.shrinkwrap.descriptor.api.jbossmodule13; 

import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Child;
import org.jboss.shrinkwrap.descriptor.api.jbossmodule13.FilterType;
import org.jboss.shrinkwrap.descriptor.api.jbossmodule13.DependenciesType;
import org.jboss.shrinkwrap.descriptor.api.jbossmodule13.ResourcesType;
import org.jboss.shrinkwrap.descriptor.api.jbossmodule13.ClassNameType;
import org.jboss.shrinkwrap.descriptor.api.jbossmodule13.PropertyListType;
import org.jboss.shrinkwrap.descriptor.api.jbossmodule13.PermissionsType;
/**
 * This interface defines the contract for the <code> moduleType </code> xsd type 
 * @author <a href="mailto:tcrawley@redhat.com">Toby Crawley</a>
 * @author <a href="mailto:alr@jboss.org">Andrew Lee Rubinger</a>
 */
public interface ModuleType<T> extends Child<T> { 

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ModuleType ElementName: jboss:filterType ElementType : exports
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>exports</code> element with the given value will be created.
    * Otherwise, the existing <code>exports</code> element will be returned.
    * @return  a new or existing instance of <code>FilterType<ModuleType<T>></code> 
    */
   public FilterType<ModuleType<T>> getOrCreateExports();

   /**
    * Removes the <code>exports</code> element 
    * @return the current instance of <code>ModuleType<T></code> 
    */
   public ModuleType<T> removeExports();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ModuleType ElementName: jboss:dependenciesType ElementType : dependencies
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>dependencies</code> element with the given value will be created.
    * Otherwise, the existing <code>dependencies</code> element will be returned.
    * @return  a new or existing instance of <code>DependenciesType<ModuleType<T>></code> 
    */
   public DependenciesType<ModuleType<T>> getOrCreateDependencies();

   /**
    * Removes the <code>dependencies</code> element 
    * @return the current instance of <code>ModuleType<T></code> 
    */
   public ModuleType<T> removeDependencies();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ModuleType ElementName: jboss:resourcesType ElementType : resources
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>resources</code> element with the given value will be created.
    * Otherwise, the existing <code>resources</code> element will be returned.
    * @return  a new or existing instance of <code>ResourcesType<ModuleType<T>></code> 
    */
   public ResourcesType<ModuleType<T>> getOrCreateResources();

   /**
    * Removes the <code>resources</code> element 
    * @return the current instance of <code>ModuleType<T></code> 
    */
   public ModuleType<T> removeResources();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ModuleType ElementName: jboss:classNameType ElementType : main-class
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>main-class</code> element with the given value will be created.
    * Otherwise, the existing <code>main-class</code> element will be returned.
    * @return  a new or existing instance of <code>ClassNameType<ModuleType<T>></code> 
    */
   public ClassNameType<ModuleType<T>> getOrCreateMainClass();

   /**
    * Removes the <code>main-class</code> element 
    * @return the current instance of <code>ModuleType<T></code> 
    */
   public ModuleType<T> removeMainClass();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ModuleType ElementName: jboss:propertyListType ElementType : properties
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>properties</code> element with the given value will be created.
    * Otherwise, the existing <code>properties</code> element will be returned.
    * @return  a new or existing instance of <code>PropertyListType<ModuleType<T>></code> 
    */
   public PropertyListType<ModuleType<T>> getOrCreateProperties();

   /**
    * Removes the <code>properties</code> element 
    * @return the current instance of <code>ModuleType<T></code> 
    */
   public ModuleType<T> removeProperties();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ModuleType ElementName: jboss:permissionsType ElementType : permissions
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>permissions</code> element with the given value will be created.
    * Otherwise, the existing <code>permissions</code> element will be returned.
    * @return  a new or existing instance of <code>PermissionsType<ModuleType<T>></code> 
    */
   public PermissionsType<ModuleType<T>> getOrCreatePermissions();

   /**
    * Removes the <code>permissions</code> element 
    * @return the current instance of <code>ModuleType<T></code> 
    */
   public ModuleType<T> removePermissions();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ModuleType ElementName: xsd:string ElementType : name
   // MaxOccurs: -  isGeneric: true   isAttribute: true isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>name</code> attribute
    * @param name the value for the attribute <code>name</code> 
    * @return the current instance of <code>ModuleType<T></code> 
    */
   public ModuleType<T> name(String name);

   /**
    * Returns the <code>name</code> attribute
    * @return the value defined for the attribute <code>name</code> 
    */
   public String getName();

   /**
    * Removes the <code>name</code> attribute 
    * @return the current instance of <code>ModuleType<T></code> 
    */
   public ModuleType<T> removeName();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ModuleType ElementName: xsd:string ElementType : slot
   // MaxOccurs: -  isGeneric: true   isAttribute: true isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>slot</code> attribute
    * @param slot the value for the attribute <code>slot</code> 
    * @return the current instance of <code>ModuleType<T></code> 
    */
   public ModuleType<T> slot(String slot);

   /**
    * Returns the <code>slot</code> attribute
    * @return the value defined for the attribute <code>slot</code> 
    */
   public String getSlot();

   /**
    * Removes the <code>slot</code> attribute 
    * @return the current instance of <code>ModuleType<T></code> 
    */
   public ModuleType<T> removeSlot();
}
