package org.jboss.shrinkwrap.descriptor.api.jbossweb60; 

/**
 * This class implements the <code> replication-modeType </code> xsd type 
 * @author <a href="mailto:ralf.battenfeld@bluewin.ch">Ralf Battenfeld</a>
 * @author <a href="mailto:alr@jboss.org">Andrew Lee Rubinger</a>
 */
public enum ReplicationModeType
{
   _SYNCHRONOUS("SYNCHRONOUS"),
   _ASYNCHRONOUS("ASYNCHRONOUS");

   private String value;

   ReplicationModeType (String value) { this.value = value; }

   public String toString() {return value;}

   public static ReplicationModeType getFromStringValue(String value)
   {
      for(ReplicationModeType type: ReplicationModeType.values())
      {
         if(value != null && type.toString().equals(value))
        { return type;}
      }
      return null;
   }

}

