package org.jboss.shrinkwrap.descriptor.api.wildflyfeaturepack11; 

import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Child;
import org.jboss.shrinkwrap.descriptor.api.wildflyfeaturepack11.CopyArtifactType;
/**
 * This interface defines the contract for the <code> copy-artifacts-type </code> xsd type 
 * @author <a href="mailto:bmcwhirt@redhat.com">Bob McWhirter</a>
 * @author <a href="mailto:alr@jboss.org">Andrew Lee Rubinger</a>
 */
public interface CopyArtifactsType<T> extends Child<T> { 

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: CopyArtifactsType ElementName: wildfly:copy-artifact-type ElementType : copy-artifact
   // MaxOccurs: -unbounded  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>copy-artifact</code> element will be created and returned.
    * Otherwise, the first existing <code>copy-artifact</code> element will be returned.
    * @return the instance defined for the element <code>copy-artifact</code> 
    */
   public CopyArtifactType<CopyArtifactsType<T>> getOrCreateCopyArtifact();

   /**
    * Creates a new <code>copy-artifact</code> element 
    * @return the new created instance of <code>CopyArtifactType<CopyArtifactsType<T>></code> 
    */
   public CopyArtifactType<CopyArtifactsType<T>> createCopyArtifact();

   /**
    * Returns all <code>copy-artifact</code> elements
    * @return list of <code>copy-artifact</code> 
    */
   public List<CopyArtifactType<CopyArtifactsType<T>>> getAllCopyArtifact();

   /**
    * Removes all <code>copy-artifact</code> elements 
    * @return the current instance of <code>CopyArtifactType<CopyArtifactsType<T>></code> 
    */
   public CopyArtifactsType<T> removeAllCopyArtifact();
}
