package org.jboss.shrinkwrap.descriptor.impl.jbosscommon51; 

import org.jboss.shrinkwrap.descriptor.spi.node.Node;
import org.jboss.shrinkwrap.descriptor.api.jbosscommon51.LoaderRepositoryConfigType;
import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Child;
import org.jboss.shrinkwrap.descriptor.impl.base.XMLDate;
import org.jboss.shrinkwrap.descriptor.impl.base.Strings;
import org.jboss.shrinkwrap.descriptor.api.DescriptorExporter;

/**
 * This class implements the <code> loader-repository-configType </code> xsd type 
 * @author <a href="mailto:ralf.battenfeld@bluewin.ch">Ralf Battenfeld</a>
 * @author <a href="mailto:alr@jboss.org">Andrew Lee Rubinger</a>
 */
public class LoaderRepositoryConfigTypeImpl<T> implements Child<T>, LoaderRepositoryConfigType<T>
{
   // -------------------------------------------------------------------------------------||
   // Instance Members 
   // -------------------------------------------------------------------------------------||

   private T t;
   private Node childNode;
   // -------------------------------------------------------------------------------------||
   // Constructor 
   // -------------------------------------------------------------------------------------||

   public LoaderRepositoryConfigTypeImpl(T t, String nodeName, Node node)   {
      this.t = t;
      this.childNode = node.createChild(nodeName);
   }

   public LoaderRepositoryConfigTypeImpl(T t, String nodeName, Node node, Node childNode)   {
      this.t = t;
      this.childNode = childNode;
   }


   public T up()
   {
      return t;
   }


 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: LoaderRepositoryConfigType ElementName: text ElementType : loader-repository-configType
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the body text for the element <code>loader-repository-configType</code> 
    * @param loaderRepositoryConfigType the value for the body text <code>loader-repository-configType</code> 
    * @return the current instance of <code>LoaderRepositoryConfigType<T></code> 
    */
   public LoaderRepositoryConfigType<T> text(String value)
   {
      childNode.text(value);
      return this;
   }

   /**
    * Returns the body text of the element <code>loader-repository-configType</code> 
    * @return the value defined for the text <code>loader-repository-configType</code> 
    */
   public String getText()
   {
      return childNode.getText();
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: LoaderRepositoryConfigType ElementName: xsd:ID ElementType : id
   // MaxOccurs: -  isGeneric: true   isAttribute: true isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>id</code> attribute
    * @param id the value for the attribute <code>id</code> 
    * @return the current instance of <code>LoaderRepositoryConfigType<T></code> 
    */
   public LoaderRepositoryConfigType<T> id(String id)
   {
      childNode.attribute("id", id);
      return this;
   }

   /**
    * Returns the <code>id</code> attribute
    * @return the value defined for the attribute <code>id</code> 
    */
      public String getId()
   {
      return childNode.getAttribute("id");
   }

   /**
    * Removes the <code>id</code> attribute 
    * @return the current instance of <code>LoaderRepositoryConfigType<T></code> 
    */
   public LoaderRepositoryConfigType<T> removeId()
   {
      childNode.removeAttribute("id");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: LoaderRepositoryConfigType ElementName: xsd:string ElementType : configParserClass
   // MaxOccurs: -  isGeneric: true   isAttribute: true isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>configParserClass</code> attribute
    * @param configParserClass the value for the attribute <code>configParserClass</code> 
    * @return the current instance of <code>LoaderRepositoryConfigType<T></code> 
    */
   public LoaderRepositoryConfigType<T> configParserClass(String configParserClass)
   {
      childNode.attribute("configParserClass", configParserClass);
      return this;
   }

   /**
    * Returns the <code>configParserClass</code> attribute
    * @return the value defined for the attribute <code>configParserClass</code> 
    */
      public String getConfigParserClass()
   {
      return childNode.getAttribute("configParserClass");
   }

   /**
    * Removes the <code>configParserClass</code> attribute 
    * @return the current instance of <code>LoaderRepositoryConfigType<T></code> 
    */
   public LoaderRepositoryConfigType<T> removeConfigParserClass()
   {
      childNode.removeAttribute("configParserClass");
      return this;
   }
}
