package org.jboss.shrinkwrap.descriptor.impl.jbossdeployment10; 

import org.jboss.shrinkwrap.descriptor.api.jbossdeployment10.JBossDeploymentStructureDescriptor;
import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Child;
import org.jboss.shrinkwrap.descriptor.impl.base.XMLDate;
import org.jboss.shrinkwrap.descriptor.impl.base.Strings;
import org.jboss.shrinkwrap.descriptor.api.DescriptorExporter;
import org.jboss.shrinkwrap.descriptor.api.jbossdeployment10.DeploymentType;
import org.jboss.shrinkwrap.descriptor.impl.jbossdeployment10.DeploymentTypeImpl;
import org.jboss.shrinkwrap.descriptor.api.jbossdeployment10.DeploymentType;
import org.jboss.shrinkwrap.descriptor.impl.jbossdeployment10.DeploymentTypeImpl;
import org.jboss.shrinkwrap.descriptor.api.jbossdeployment10.ModuleType;
import org.jboss.shrinkwrap.descriptor.impl.jbossdeployment10.ModuleTypeImpl;
import java.util.Map.Entry;

import org.jboss.shrinkwrap.descriptor.api.DescriptorNamespace;

import org.jboss.shrinkwrap.descriptor.spi.node.NodeDescriptorImplBase;
import org.jboss.shrinkwrap.descriptor.impl.base.XMLDate;
import org.jboss.shrinkwrap.descriptor.spi.node.Node;

/** 
 * <p> 
 * This deployment descriptor provides the functionalities as described in the  specification
 * <p> 
 * Example:
 * <p> 
 * <code> 
 *     JBossDeploymentStructureDescriptor descriptor = Descriptors.create(JBossDeploymentStructureDescriptor.class);
 * </code> 
 *
 *
 * @author <a href="mailto:ralf.battenfeld@bluewin.ch">Ralf Battenfeld</a>
 * @author <a href="mailto:alr@jboss.org">Andrew Lee Rubinger</a>
 */
public class JBossDeploymentStructureDescriptorImpl extends NodeDescriptorImplBase implements DescriptorNamespace<JBossDeploymentStructureDescriptor>, JBossDeploymentStructureDescriptor
{
   // -------------------------------------------------------------------------------------||
   // Instance Members 
   // -------------------------------------------------------------------------------------||

   private Node model;

   // -------------------------------------------------------------------------------------||
   // Constructor 
   // -------------------------------------------------------------------------------------||

   public JBossDeploymentStructureDescriptorImpl(String descriptorName)
   {
       this(descriptorName, new Node("jboss-deployment-structure"));
   }

   public JBossDeploymentStructureDescriptorImpl(String descriptorName, Node node)
   {
      super(descriptorName);
      this.model = node;
      addDefaultNamespaces();
   }

   // -------------------------------------------------------------------------------------||
   // Methods 
   // -------------------------------------------------------------------------------------||

   public Node getRootNode()
   {
      return model;
   }



   // -------------------------------------------------------------------------------------||
   // Namespace 
   // -------------------------------------------------------------------------------------||


   /**
    * Adds the default namespaces as defined in the specification 
    * @return the current instance of <code>JBossDeploymentStructureDescriptor</code> 
    */
   public JBossDeploymentStructureDescriptor addDefaultNamespaces()
   {
      addNamespace("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
      addNamespace("xsi:schemaLocation", "urn:jboss:deployment-structure:1.0 jboss-deployment-structure-1_0.xsd");
      addNamespace("xmlns", "urn:jboss:deployment-structure:1.0");
     return this;
   }

   /**
    * Adds a new namespace 
    * @return the current instance of <code>JBossDeploymentStructureDescriptor</code> 
    */
   public JBossDeploymentStructureDescriptor addNamespace(String name, String value)
   {
      model.attribute(name, value);
      return this;
   }

   /**
    * Returns all defined namespaces. 
    * @return all defined namespaces 
    */
   public List<String> getNamespaces()
   {
      List<String> namespaceList = new ArrayList<String>();
      java.util.Map<String, String> attributes = model.getAttributes();
      for (Entry<String, String> e : attributes.entrySet())
      {
         final String name = e.getKey();
         final String value = e.getValue();
         if (value != null && value.startsWith("http://")) 
         {
            namespaceList.add(name + "=" + value);
         }
      }
      return namespaceList;
   }

   /**
    * Removes all existing namespaces. 
    * @return the current instance of <code>JBossDeploymentStructureDescriptor</code> 
    */
   public JBossDeploymentStructureDescriptor removeAllNamespaces()
   {
      List<String> nameSpaceKeys = new ArrayList<String>();
      java.util.Map<String, String> attributes = model.getAttributes();
      for (Entry<String, String> e : attributes.entrySet())
      {
         final String name = e.getKey();
         final String value = e.getValue();
         if (value != null && value.startsWith("http://")) 
         {
            nameSpaceKeys.add(name);
         }
      }
      for (String name: nameSpaceKeys)
      {
         model.removeAttribute(name);
      }
      return this;
   }
 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: JBossDeploymentStructureDescriptor ElementName: xsd:boolean ElementType : ear-subdeployments-isolated
   // MaxOccurs: -1  isGeneric: false   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>ear-subdeployments-isolated</code> element
    * @param earSubdeploymentsIsolated the value for the element <code>ear-subdeployments-isolated</code> 
    * @return the current instance of <code>JBossDeploymentStructureDescriptor</code> 
    */
   public JBossDeploymentStructureDescriptor earSubdeploymentsIsolated(Boolean earSubdeploymentsIsolated)
   {
      model.getOrCreate("ear-subdeployments-isolated").text(earSubdeploymentsIsolated);
      return this;
   }

   /**
    * Returns the <code>ear-subdeployments-isolated</code> element
    * @return the node defined for the element <code>ear-subdeployments-isolated</code> 
    */
   public Boolean isEarSubdeploymentsIsolated()
   {
      return Strings.isTrue(model.getTextValueForPatternName("ear-subdeployments-isolated"));
   }

   /**
    * Removes the <code>ear-subdeployments-isolated</code> element 
    * @return the current instance of <code>JBossDeploymentStructureDescriptor</code> 
    */
   public JBossDeploymentStructureDescriptor removeEarSubdeploymentsIsolated()
   {
      model.removeChildren("ear-subdeployments-isolated");
      return this;
   }
 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: JBossDeploymentStructureDescriptor ElementName: jboss:deploymentType ElementType : deployment
   // MaxOccurs: -1  isGeneric: false   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>deployment</code> element with the given value will be created.
    * Otherwise, the existing <code>deployment</code> element will be returned.
    * @return  a new or existing instance of <code>DeploymentType<JBossDeploymentStructureDescriptor></code> 
    */
   public DeploymentType<JBossDeploymentStructureDescriptor> getOrCreateDeployment()
   {
      Node node = model.getOrCreate("deployment");
      DeploymentType<JBossDeploymentStructureDescriptor> deployment = new DeploymentTypeImpl<JBossDeploymentStructureDescriptor>(this, "deployment", model, node);
      return deployment;
   }

   /**
    * Removes the <code>deployment</code> element 
    * @return the current instance of <code>JBossDeploymentStructureDescriptor</code> 
    */
   public JBossDeploymentStructureDescriptor removeDeployment()
   {
      model.removeChildren("deployment");
      return this;
   }
 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: JBossDeploymentStructureDescriptor ElementName: jboss:deploymentType ElementType : sub-deployment
   // MaxOccurs: -unbounded  isGeneric: false   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>sub-deployment</code> element will be created and returned.
    * Otherwise, the first existing <code>sub-deployment</code> element will be returned.
    * @return the instance defined for the element <code>sub-deployment</code> 
    */
   public DeploymentType<JBossDeploymentStructureDescriptor> getOrCreateSubDeployment()
   {
      List<Node> nodeList = model.get("sub-deployment");
      if (nodeList != null &&  nodeList.size() > 0)
      {
         return new DeploymentTypeImpl<JBossDeploymentStructureDescriptor>(this, "sub-deployment", model, nodeList.get(0));
      }
      return createSubDeployment();
   }

   /**
    * Creates a new <code>sub-deployment</code> element 
    * @return the new created instance of <code>DeploymentType<JBossDeploymentStructureDescriptor></code> 
    */
   public DeploymentType<JBossDeploymentStructureDescriptor> createSubDeployment()
   {
      return new DeploymentTypeImpl<JBossDeploymentStructureDescriptor>(this, "sub-deployment", model);
   }

   /**
    * Returns all <code>sub-deployment</code> elements
    * @return list of <code>sub-deployment</code> 
    */
   public List<DeploymentType<JBossDeploymentStructureDescriptor>> getAllSubDeployment()
   {
      List<DeploymentType<JBossDeploymentStructureDescriptor>> list = new ArrayList<DeploymentType<JBossDeploymentStructureDescriptor>>();
      List<Node> nodeList = model.get("sub-deployment");
      for(Node node: nodeList)
      {
         DeploymentType<JBossDeploymentStructureDescriptor>  type = new DeploymentTypeImpl<JBossDeploymentStructureDescriptor>(this, "sub-deployment", model, node);
         list.add(type);
      }
      return list;
   }

   /**
    * Removes all <code>sub-deployment</code> elements 
    * @return the current instance of <code>DeploymentType<JBossDeploymentStructureDescriptor></code> 
    */
   public JBossDeploymentStructureDescriptor removeAllSubDeployment()
   {
      model.removeChildren("sub-deployment");
      return this;
   }
 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: JBossDeploymentStructureDescriptor ElementName: jboss:moduleType ElementType : module
   // MaxOccurs: -unbounded  isGeneric: false   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>module</code> element will be created and returned.
    * Otherwise, the first existing <code>module</code> element will be returned.
    * @return the instance defined for the element <code>module</code> 
    */
   public ModuleType<JBossDeploymentStructureDescriptor> getOrCreateModule()
   {
      List<Node> nodeList = model.get("module");
      if (nodeList != null &&  nodeList.size() > 0)
      {
         return new ModuleTypeImpl<JBossDeploymentStructureDescriptor>(this, "module", model, nodeList.get(0));
      }
      return createModule();
   }

   /**
    * Creates a new <code>module</code> element 
    * @return the new created instance of <code>ModuleType<JBossDeploymentStructureDescriptor></code> 
    */
   public ModuleType<JBossDeploymentStructureDescriptor> createModule()
   {
      return new ModuleTypeImpl<JBossDeploymentStructureDescriptor>(this, "module", model);
   }

   /**
    * Returns all <code>module</code> elements
    * @return list of <code>module</code> 
    */
   public List<ModuleType<JBossDeploymentStructureDescriptor>> getAllModule()
   {
      List<ModuleType<JBossDeploymentStructureDescriptor>> list = new ArrayList<ModuleType<JBossDeploymentStructureDescriptor>>();
      List<Node> nodeList = model.get("module");
      for(Node node: nodeList)
      {
         ModuleType<JBossDeploymentStructureDescriptor>  type = new ModuleTypeImpl<JBossDeploymentStructureDescriptor>(this, "module", model, node);
         list.add(type);
      }
      return list;
   }

   /**
    * Removes all <code>module</code> elements 
    * @return the current instance of <code>ModuleType<JBossDeploymentStructureDescriptor></code> 
    */
   public JBossDeploymentStructureDescriptor removeAllModule()
   {
      model.removeChildren("module");
      return this;
   }

}
