package org.jboss.shrinkwrap.descriptor.impl.wildflyfeaturepack11; 

import org.jboss.shrinkwrap.descriptor.spi.node.Node;
import org.jboss.shrinkwrap.descriptor.api.wildflyfeaturepack11.ConfigFileType;
import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Child;
import org.jboss.shrinkwrap.descriptor.impl.base.XMLDate;
import org.jboss.shrinkwrap.descriptor.impl.base.Strings;
import org.jboss.shrinkwrap.descriptor.api.DescriptorExporter;
import org.jboss.shrinkwrap.descriptor.api.wildflyfeaturepack11.PropertyType;
import org.jboss.shrinkwrap.descriptor.impl.wildflyfeaturepack11.PropertyTypeImpl;

/**
 * This class implements the <code> config-file-type </code> xsd type 
 * @author <a href="mailto:bmcwhirt@redhat.com">Bob McWhirter</a>
 * @author <a href="mailto:alr@jboss.org">Andrew Lee Rubinger</a>
 */
public class ConfigFileTypeImpl<T> implements Child<T>, ConfigFileType<T>
{
   // -------------------------------------------------------------------------------------||
   // Instance Members 
   // -------------------------------------------------------------------------------------||

   private T t;
   private Node childNode;
   // -------------------------------------------------------------------------------------||
   // Constructor 
   // -------------------------------------------------------------------------------------||

   public ConfigFileTypeImpl(T t, String nodeName, Node node)   {
      this.t = t;
      this.childNode = node.createChild(nodeName);
   }

   public ConfigFileTypeImpl(T t, String nodeName, Node node, Node childNode)   {
      this.t = t;
      this.childNode = childNode;
   }


   public T up()
   {
      return t;
   }


 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ConfigFileType ElementName: wildfly:property-type ElementType : property
   // MaxOccurs: -unbounded  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>property</code> element will be created and returned.
    * Otherwise, the first existing <code>property</code> element will be returned.
    * @return the instance defined for the element <code>property</code> 
    */
   public PropertyType<ConfigFileType<T>> getOrCreateProperty()
   {
      List<Node> nodeList = childNode.get("property");
      if (nodeList != null &&  nodeList.size() > 0)
      {
         return new PropertyTypeImpl<ConfigFileType<T>>(this, "property", childNode, nodeList.get(0));
      }
      return createProperty();
   }

   /**
    * Creates a new <code>property</code> element 
    * @return the new created instance of <code>PropertyType<ConfigFileType<T>></code> 
    */
   public PropertyType<ConfigFileType<T>> createProperty()
   {
      return new PropertyTypeImpl<ConfigFileType<T>>(this, "property", childNode);
   }

   /**
    * Returns all <code>property</code> elements
    * @return list of <code>property</code> 
    */
   public List<PropertyType<ConfigFileType<T>>> getAllProperty()
   {
      List<PropertyType<ConfigFileType<T>>> list = new ArrayList<PropertyType<ConfigFileType<T>>>();
      List<Node> nodeList = childNode.get("property");
      for(Node node: nodeList)
      {
         PropertyType<ConfigFileType<T>>  type = new PropertyTypeImpl<ConfigFileType<T>>(this, "property", childNode, node);
         list.add(type);
      }
      return list;
   }

   /**
    * Removes all <code>property</code> elements 
    * @return the current instance of <code>PropertyType<ConfigFileType<T>></code> 
    */
   public ConfigFileType<T> removeAllProperty()
   {
      childNode.removeChildren("property");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ConfigFileType ElementName: xsd:string ElementType : template
   // MaxOccurs: -  isGeneric: true   isAttribute: true isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>template</code> attribute
    * @param template the value for the attribute <code>template</code> 
    * @return the current instance of <code>ConfigFileType<T></code> 
    */
   public ConfigFileType<T> template(String template)
   {
      childNode.attribute("template", template);
      return this;
   }

   /**
    * Returns the <code>template</code> attribute
    * @return the value defined for the attribute <code>template</code> 
    */
      public String getTemplate()
   {
      return childNode.getAttribute("template");
   }

   /**
    * Removes the <code>template</code> attribute 
    * @return the current instance of <code>ConfigFileType<T></code> 
    */
   public ConfigFileType<T> removeTemplate()
   {
      childNode.removeAttribute("template");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ConfigFileType ElementName: xsd:string ElementType : subsystems
   // MaxOccurs: -  isGeneric: true   isAttribute: true isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>subsystems</code> attribute
    * @param subsystems the value for the attribute <code>subsystems</code> 
    * @return the current instance of <code>ConfigFileType<T></code> 
    */
   public ConfigFileType<T> subsystems(String subsystems)
   {
      childNode.attribute("subsystems", subsystems);
      return this;
   }

   /**
    * Returns the <code>subsystems</code> attribute
    * @return the value defined for the attribute <code>subsystems</code> 
    */
      public String getSubsystems()
   {
      return childNode.getAttribute("subsystems");
   }

   /**
    * Removes the <code>subsystems</code> attribute 
    * @return the current instance of <code>ConfigFileType<T></code> 
    */
   public ConfigFileType<T> removeSubsystems()
   {
      childNode.removeAttribute("subsystems");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ConfigFileType ElementName: xsd:string ElementType : output-file
   // MaxOccurs: -  isGeneric: true   isAttribute: true isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>output-file</code> attribute
    * @param outputFile the value for the attribute <code>output-file</code> 
    * @return the current instance of <code>ConfigFileType<T></code> 
    */
   public ConfigFileType<T> outputFile(String outputFile)
   {
      childNode.attribute("output-file", outputFile);
      return this;
   }

   /**
    * Returns the <code>output-file</code> attribute
    * @return the value defined for the attribute <code>output-file</code> 
    */
      public String getOutputFile()
   {
      return childNode.getAttribute("output-file");
   }

   /**
    * Removes the <code>output-file</code> attribute 
    * @return the current instance of <code>ConfigFileType<T></code> 
    */
   public ConfigFileType<T> removeOutputFile()
   {
      childNode.removeAttribute("output-file");
      return this;
   }
}
