package org.jboss.shrinkwrap.descriptor.impl.wildflyfeaturepack11; 

import org.jboss.shrinkwrap.descriptor.spi.node.Node;
import org.jboss.shrinkwrap.descriptor.api.wildflyfeaturepack11.FilterType;
import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Child;
import org.jboss.shrinkwrap.descriptor.impl.base.XMLDate;
import org.jboss.shrinkwrap.descriptor.impl.base.Strings;
import org.jboss.shrinkwrap.descriptor.api.DescriptorExporter;

/**
 * This class implements the <code> filter-type </code> xsd type 
 * @author <a href="mailto:bmcwhirt@redhat.com">Bob McWhirter</a>
 * @author <a href="mailto:alr@jboss.org">Andrew Lee Rubinger</a>
 */
public class FilterTypeImpl<T> implements Child<T>, FilterType<T>
{
   // -------------------------------------------------------------------------------------||
   // Instance Members 
   // -------------------------------------------------------------------------------------||

   private T t;
   private Node childNode;
   // -------------------------------------------------------------------------------------||
   // Constructor 
   // -------------------------------------------------------------------------------------||

   public FilterTypeImpl(T t, String nodeName, Node node)   {
      this.t = t;
      this.childNode = node.createChild(nodeName);
   }

   public FilterTypeImpl(T t, String nodeName, Node node, Node childNode)   {
      this.t = t;
      this.childNode = childNode;
   }


   public T up()
   {
      return t;
   }


 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: FilterType ElementName: xsd:string ElementType : pattern
   // MaxOccurs: -  isGeneric: true   isAttribute: true isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>pattern</code> attribute
    * @param pattern the value for the attribute <code>pattern</code> 
    * @return the current instance of <code>FilterType<T></code> 
    */
   public FilterType<T> pattern(String pattern)
   {
      childNode.attribute("pattern", pattern);
      return this;
   }

   /**
    * Returns the <code>pattern</code> attribute
    * @return the value defined for the attribute <code>pattern</code> 
    */
      public String getPattern()
   {
      return childNode.getAttribute("pattern");
   }

   /**
    * Removes the <code>pattern</code> attribute 
    * @return the current instance of <code>FilterType<T></code> 
    */
   public FilterType<T> removePattern()
   {
      childNode.removeAttribute("pattern");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: FilterType ElementName: xsd:boolean ElementType : include
   // MaxOccurs: -  isGeneric: true   isAttribute: true isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>include</code> attribute
    * @param include the value for the attribute <code>include</code> 
    * @return the current instance of <code>FilterType<T></code> 
    */
   public FilterType<T> include(Boolean include)
   {
      childNode.attribute("include", include);
      return this;
   }

   /**
    * Returns the <code>include</code> attribute
    * @return the value defined for the attribute <code>include</code> 
    */
   public Boolean isInclude()
   {
      return Strings.isTrue(childNode.getAttribute("include"));
   }

   /**
    * Removes the <code>include</code> attribute 
    * @return the current instance of <code>FilterType<T></code> 
    */
   public FilterType<T> removeInclude()
   {
      childNode.removeAttribute("include");
      return this;
   }
}
