package org.wildfly.swarm.config;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import java.util.HashMap;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Implicit;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import java.util.List;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.keycloak.SecureDeploymentConsumer;
import org.wildfly.swarm.config.keycloak.SecureDeploymentSupplier;
import org.wildfly.swarm.config.keycloak.SecureDeployment;
import org.wildfly.swarm.config.runtime.SubresourceInfo;
import org.wildfly.swarm.config.keycloak.RealmConsumer;
import org.wildfly.swarm.config.keycloak.RealmSupplier;
import org.wildfly.swarm.config.keycloak.Realm;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;

/**
 * Keycloak adapter subsystem
 */
@Address("/subsystem=keycloak")
@ResourceType("subsystem")
@Implicit
public class Keycloak<T extends Keycloak<T>> extends HashMap
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	private KeycloakResources subresources = new KeycloakResources();

	public Keycloak() {
		super();
		this.key = "keycloak";
		this.pcs = new PropertyChangeSupport(this);
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	public KeycloakResources subresources() {
		return this.subresources;
	}

	/**
	 * Add all SecureDeployment objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of SecureDeployment objects.
	 */
	@SuppressWarnings("unchecked")
	public T secureDeployments(java.util.List<SecureDeployment> value) {
		this.subresources.secureDeployments = value;
		return (T) this;
	}

	/**
	 * Add the SecureDeployment object to the list of subresources
	 * 
	 * @param value
	 *            The SecureDeployment to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T secureDeployment(SecureDeployment value) {
		this.subresources.secureDeployments.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a SecureDeployment object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the SecureDeployment resource
	 * @param config
	 *            The SecureDeploymentConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T secureDeployment(java.lang.String childKey,
			SecureDeploymentConsumer consumer) {
		SecureDeployment<? extends SecureDeployment> child = new SecureDeployment<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		secureDeployment(child);
		return (T) this;
	}

	/**
	 * Create and configure a SecureDeployment object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the SecureDeployment resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T secureDeployment(java.lang.String childKey) {
		secureDeployment(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied SecureDeployment object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T secureDeployment(SecureDeploymentSupplier supplier) {
		secureDeployment(supplier.get());
		return (T) this;
	}

	/**
	 * Add all Realm objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of Realm objects.
	 */
	@SuppressWarnings("unchecked")
	public T realms(java.util.List<Realm> value) {
		this.subresources.realms = value;
		return (T) this;
	}

	/**
	 * Add the Realm object to the list of subresources
	 * 
	 * @param value
	 *            The Realm to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T realm(Realm value) {
		this.subresources.realms.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a Realm object to the list of subresources
	 * 
	 * @param key
	 *            The key for the Realm resource
	 * @param config
	 *            The RealmConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T realm(java.lang.String childKey, RealmConsumer consumer) {
		Realm<? extends Realm> child = new Realm<>(childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		realm(child);
		return (T) this;
	}

	/**
	 * Create and configure a Realm object to the list of subresources
	 * 
	 * @param key
	 *            The key for the Realm resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T realm(java.lang.String childKey) {
		realm(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied Realm object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T realm(RealmSupplier supplier) {
		realm(supplier.get());
		return (T) this;
	}

	/**
	 * Child mutators for Keycloak
	 */
	public static class KeycloakResources {
		/**
		 * A deployment secured by Keycloak
		 */
		@ResourceDocumentation("A deployment secured by Keycloak")
		@SubresourceInfo("secureDeployment")
		private List<SecureDeployment> secureDeployments = new java.util.ArrayList<>();
		/**
		 * A Keycloak realm.
		 */
		@ResourceDocumentation("A Keycloak realm.")
		@SubresourceInfo("realm")
		private List<Realm> realms = new java.util.ArrayList<>();

		/**
		 * Get the list of SecureDeployment resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<SecureDeployment> secureDeployments() {
			return this.secureDeployments;
		}

		public SecureDeployment secureDeployment(java.lang.String key) {
			return this.secureDeployments.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Get the list of Realm resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<Realm> realms() {
			return this.realms;
		}

		public Realm realm(java.lang.String key) {
			return this.realms.stream().filter(e -> e.getKey().equals(key))
					.findFirst().orElse(null);
		}
	}
}