package org.jboss.shrinkwrap.descriptor.impl.beans11; 

import org.jboss.shrinkwrap.descriptor.spi.node.Node;
import org.jboss.shrinkwrap.descriptor.api.beans11.Scan;
import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Child;
import org.jboss.shrinkwrap.descriptor.impl.base.XMLDate;
import org.jboss.shrinkwrap.descriptor.impl.base.Strings;
import org.jboss.shrinkwrap.descriptor.api.DescriptorExporter;
import org.jboss.shrinkwrap.descriptor.api.beans11.Exclude;
import org.jboss.shrinkwrap.descriptor.impl.beans11.ExcludeImpl;

/**
 * This class implements the <code> scan </code> xsd type 
 * @author <a href="mailto:ralf.battenfeld@bluewin.ch">Ralf Battenfeld</a>
 * @author <a href="mailto:alr@jboss.org">Andrew Lee Rubinger</a>
 */
public class ScanImpl<T> implements Child<T>, Scan<T>
{
   // -------------------------------------------------------------------------------------||
   // Instance Members 
   // -------------------------------------------------------------------------------------||

   private T t;
   private Node childNode;
   // -------------------------------------------------------------------------------------||
   // Constructor 
   // -------------------------------------------------------------------------------------||

   public ScanImpl(T t, String nodeName, Node node)   {
      this.t = t;
      this.childNode = node.createChild(nodeName);
   }

   public ScanImpl(T t, String nodeName, Node node, Node childNode)   {
      this.t = t;
      this.childNode = childNode;
   }


   public T up()
   {
      return t;
   }


 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: Scan ElementName: javaee:exclude ElementType : exclude
   // MaxOccurs: -unbounded  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>exclude</code> element will be created and returned.
    * Otherwise, the first existing <code>exclude</code> element will be returned.
    * @return the instance defined for the element <code>exclude</code> 
    */
   public Exclude<Scan<T>> getOrCreateExclude()
   {
      List<Node> nodeList = childNode.get("exclude");
      if (nodeList != null &&  nodeList.size() > 0)
      {
         return new ExcludeImpl<Scan<T>>(this, "exclude", childNode, nodeList.get(0));
      }
      return createExclude();
   }

   /**
    * Creates a new <code>exclude</code> element 
    * @return the new created instance of <code>Exclude<Scan<T>></code> 
    */
   public Exclude<Scan<T>> createExclude()
   {
      return new ExcludeImpl<Scan<T>>(this, "exclude", childNode);
   }

   /**
    * Returns all <code>exclude</code> elements
    * @return list of <code>exclude</code> 
    */
   public List<Exclude<Scan<T>>> getAllExclude()
   {
      List<Exclude<Scan<T>>> list = new ArrayList<Exclude<Scan<T>>>();
      List<Node> nodeList = childNode.get("exclude");
      for(Node node: nodeList)
      {
         Exclude<Scan<T>>  type = new ExcludeImpl<Scan<T>>(this, "exclude", childNode, node);
         list.add(type);
      }
      return list;
   }

   /**
    * Removes all <code>exclude</code> elements 
    * @return the current instance of <code>Exclude<Scan<T>></code> 
    */
   public Scan<T> removeAllExclude()
   {
      childNode.removeChildren("exclude");
      return this;
   }
}
