package org.wildfly.swarm.config;

import org.wildfly.swarm.config.Jdr;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface JdrConsumer<T extends Jdr<T>> {

	/**
	 * Configure a pre-constructed instance of Jdr resource
	 * 
	 * @parameter Instance of Jdr to configure
	 * @return nothing
	 */
	void accept(T value);

	default JdrConsumer<T> andThen(JdrConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}