package org.wildfly.swarm.config;

import org.wildfly.swarm.config.Transactions;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface TransactionsConsumer<T extends Transactions<T>> {

	/**
	 * Configure a pre-constructed instance of Transactions resource
	 * 
	 * @parameter Instance of Transactions to configure
	 * @return nothing
	 */
	void accept(T value);

	default TransactionsConsumer<T> andThen(TransactionsConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}