package org.wildfly.swarm.config.infinispan.cache_container;

import org.wildfly.swarm.config.infinispan.cache_container.BehindWrite;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface BehindWriteConsumer<T extends BehindWrite<T>> {

	/**
	 * Configure a pre-constructed instance of BehindWrite resource
	 * 
	 * @parameter Instance of BehindWrite to configure
	 * @return nothing
	 */
	void accept(T value);

	default BehindWriteConsumer<T> andThen(BehindWriteConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}