package org.wildfly.swarm.config.management;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import java.util.HashMap;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Implicit;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;

/**
 * Service to store and list configuration changes.
 */
@Address("/core-service=management/service=configuration-changes")
@ResourceType("service")
@Implicit
public class ConfigurationChangesService<T extends ConfigurationChangesService<T>>
		extends
			HashMap implements org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	@AttributeDocumentation("The maximum number of configuration changes stored in history.")
	private Integer maxHistory;

	public ConfigurationChangesService() {
		super();
		this.key = "configuration-changes";
		this.pcs = new PropertyChangeSupport(this);
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * The maximum number of configuration changes stored in history.
	 */
	@ModelNodeBinding(detypedName = "max-history")
	public Integer maxHistory() {
		return this.maxHistory;
	}

	/**
	 * The maximum number of configuration changes stored in history.
	 */
	@SuppressWarnings("unchecked")
	public T maxHistory(java.lang.Integer value) {
		Object oldValue = this.maxHistory;
		this.maxHistory = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("maxHistory", oldValue, value);
		return (T) this;
	}
}