package org.wildfly.swarm.config.management.security_realm;

import org.wildfly.swarm.config.management.security_realm.KerberosAuthentication;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface KerberosAuthenticationConsumer<T extends KerberosAuthentication<T>> {

	/**
	 * Configure a pre-constructed instance of KerberosAuthentication resource
	 * 
	 * @parameter Instance of KerberosAuthentication to configure
	 * @return nothing
	 */
	void accept(T value);

	default KerberosAuthenticationConsumer<T> andThen(
			KerberosAuthenticationConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}