package org.wildfly.swarm.config.messaging.activemq.server;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import java.util.HashMap;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import java.util.List;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.messaging.activemq.server.RoleConsumer;
import org.wildfly.swarm.config.messaging.activemq.server.RoleSupplier;
import org.wildfly.swarm.config.messaging.activemq.server.Role;
import org.wildfly.swarm.config.runtime.SubresourceInfo;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.Arrays;
import java.util.stream.Collectors;

/**
 * A runtime-only resource representing a ActiveMQ "address". Zero or more
 * queues can be bound to a single address. When a message is routed, it is
 * routed to the set of queues bound to the message's address.
 */
@Address("/subsystem=messaging-activemq/server=*/core-address=*")
@ResourceType("core-address")
public class CoreAddress<T extends CoreAddress<T>> extends HashMap
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	private CoreAddressResources subresources = new CoreAddressResources();
	@AttributeDocumentation("The names of all bindings (both queues and diverts) bound to this address.")
	private List<String> bindingNames;
	@AttributeDocumentation("The number of bytes used by each page for this address.")
	private Long numberOfBytesPerPage;
	@AttributeDocumentation("The number of pages used by this address.")
	private Integer numberOfPages;
	@AttributeDocumentation("The names of the queues associated with the address.")
	private List<String> queueNames;

	public CoreAddress(java.lang.String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	public CoreAddressResources subresources() {
		return this.subresources;
	}

	/**
	 * Add all Role objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of Role objects.
	 */
	@SuppressWarnings("unchecked")
	public T roles(java.util.List<Role> value) {
		this.subresources.roles = value;
		return (T) this;
	}

	/**
	 * Add the Role object to the list of subresources
	 * 
	 * @param value
	 *            The Role to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T role(Role value) {
		this.subresources.roles.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a Role object to the list of subresources
	 * 
	 * @param key
	 *            The key for the Role resource
	 * @param config
	 *            The RoleConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T role(java.lang.String childKey, RoleConsumer consumer) {
		Role<? extends Role> child = new Role<>(childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		role(child);
		return (T) this;
	}

	/**
	 * Create and configure a Role object to the list of subresources
	 * 
	 * @param key
	 *            The key for the Role resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T role(java.lang.String childKey) {
		role(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied Role object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T role(RoleSupplier supplier) {
		role(supplier.get());
		return (T) this;
	}

	/**
	 * Child mutators for CoreAddress
	 */
	public static class CoreAddressResources {
		/**
		 * A security role.
		 */
		@ResourceDocumentation("A security role.")
		@SubresourceInfo("role")
		private List<Role> roles = new java.util.ArrayList<>();

		/**
		 * Get the list of Role resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<Role> roles() {
			return this.roles;
		}

		public Role role(java.lang.String key) {
			return this.roles.stream().filter(e -> e.getKey().equals(key))
					.findFirst().orElse(null);
		}
	}

	/**
	 * The names of all bindings (both queues and diverts) bound to this
	 * address.
	 */
	@ModelNodeBinding(detypedName = "binding-names")
	public List<String> bindingNames() {
		return this.bindingNames;
	}

	/**
	 * The names of all bindings (both queues and diverts) bound to this
	 * address.
	 */
	@SuppressWarnings("unchecked")
	public T bindingNames(java.util.List<String> value) {
		Object oldValue = this.bindingNames;
		this.bindingNames = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("bindingNames", oldValue, value);
		return (T) this;
	}

	/**
	 * The names of all bindings (both queues and diverts) bound to this
	 * address.
	 */
	@SuppressWarnings("unchecked")
	public T bindingName(String value) {
		if (this.bindingNames == null) {
			this.bindingNames = new java.util.ArrayList<>();
		}
		this.bindingNames.add(value);
		return (T) this;
	}

	/**
	 * The names of all bindings (both queues and diverts) bound to this
	 * address.
	 */
	@SuppressWarnings("unchecked")
	public T bindingNames(String... args) {
		bindingNames(Arrays.stream(args).collect(Collectors.toList()));
		return (T) this;
	}

	/**
	 * The number of bytes used by each page for this address.
	 */
	@ModelNodeBinding(detypedName = "number-of-bytes-per-page")
	public Long numberOfBytesPerPage() {
		return this.numberOfBytesPerPage;
	}

	/**
	 * The number of bytes used by each page for this address.
	 */
	@SuppressWarnings("unchecked")
	public T numberOfBytesPerPage(java.lang.Long value) {
		Object oldValue = this.numberOfBytesPerPage;
		this.numberOfBytesPerPage = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("numberOfBytesPerPage", oldValue, value);
		return (T) this;
	}

	/**
	 * The number of pages used by this address.
	 */
	@ModelNodeBinding(detypedName = "number-of-pages")
	public Integer numberOfPages() {
		return this.numberOfPages;
	}

	/**
	 * The number of pages used by this address.
	 */
	@SuppressWarnings("unchecked")
	public T numberOfPages(java.lang.Integer value) {
		Object oldValue = this.numberOfPages;
		this.numberOfPages = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("numberOfPages", oldValue, value);
		return (T) this;
	}

	/**
	 * The names of the queues associated with the address.
	 */
	@ModelNodeBinding(detypedName = "queue-names")
	public List<String> queueNames() {
		return this.queueNames;
	}

	/**
	 * The names of the queues associated with the address.
	 */
	@SuppressWarnings("unchecked")
	public T queueNames(java.util.List<String> value) {
		Object oldValue = this.queueNames;
		this.queueNames = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("queueNames", oldValue, value);
		return (T) this;
	}

	/**
	 * The names of the queues associated with the address.
	 */
	@SuppressWarnings("unchecked")
	public T queueName(String value) {
		if (this.queueNames == null) {
			this.queueNames = new java.util.ArrayList<>();
		}
		this.queueNames.add(value);
		return (T) this;
	}

	/**
	 * The names of the queues associated with the address.
	 */
	@SuppressWarnings("unchecked")
	public T queueNames(String... args) {
		queueNames(Arrays.stream(args).collect(Collectors.toList()));
		return (T) this;
	}
}