package org.wildfly.swarm.config.messaging.activemq.server;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import java.util.HashMap;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.Arrays;

/**
 * Makes decisions about which node in a cluster should handle a message with a
 * group id assigned.
 */
@Address("/subsystem=messaging-activemq/server=*/grouping-handler=*")
@ResourceType("grouping-handler")
public class GroupingHandler<T extends GroupingHandler<T>> extends HashMap
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	@AttributeDocumentation("How long a group binding will be used, -1 means for ever. Bindings are removed after this wait elapses (valid for both LOCAL and REMOTE handlers).")
	private Long groupTimeout;
	@AttributeDocumentation("A reference to a cluster connection and the address it uses.")
	private String groupingHandlerAddress;
	@AttributeDocumentation("How often the reaper will be run to check for timed out group bindings (only valid for LOCAL handlers).")
	private Long reaperPeriod;
	@AttributeDocumentation("How long to wait for a handling decision to be made; an exception will be thrown during the send if this timeout is reached, ensuring that strict ordering is kept.")
	private Long timeout;
	@AttributeDocumentation("Whether the handler is the single \"Local\" handler for the cluster, which makes handling decisions, or a \"Remote\" handler which converses with the local handler.")
	private Type type;

	public GroupingHandler(java.lang.String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	public static enum Type {
		LOCAL("LOCAL"), REMOTE("REMOTE");
		private final String allowedValue;

		/**
		 * Returns the allowed value for the management model.
		 * 
		 * @return the allowed model value
		 */
		public String getAllowedValue() {
			return allowedValue;
		}

		Type(java.lang.String allowedValue) {
			this.allowedValue = allowedValue;
		}

		@Override
		public String toString() {
			return allowedValue;
		}
	}

	/**
	 * How long a group binding will be used, -1 means for ever. Bindings are
	 * removed after this wait elapses (valid for both LOCAL and REMOTE
	 * handlers).
	 */
	@ModelNodeBinding(detypedName = "group-timeout")
	public Long groupTimeout() {
		return this.groupTimeout;
	}

	/**
	 * How long a group binding will be used, -1 means for ever. Bindings are
	 * removed after this wait elapses (valid for both LOCAL and REMOTE
	 * handlers).
	 */
	@SuppressWarnings("unchecked")
	public T groupTimeout(java.lang.Long value) {
		Object oldValue = this.groupTimeout;
		this.groupTimeout = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("groupTimeout", oldValue, value);
		return (T) this;
	}

	/**
	 * A reference to a cluster connection and the address it uses.
	 */
	@ModelNodeBinding(detypedName = "grouping-handler-address")
	public String groupingHandlerAddress() {
		return this.groupingHandlerAddress;
	}

	/**
	 * A reference to a cluster connection and the address it uses.
	 */
	@SuppressWarnings("unchecked")
	public T groupingHandlerAddress(java.lang.String value) {
		Object oldValue = this.groupingHandlerAddress;
		this.groupingHandlerAddress = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("groupingHandlerAddress", oldValue,
					value);
		return (T) this;
	}

	/**
	 * How often the reaper will be run to check for timed out group bindings
	 * (only valid for LOCAL handlers).
	 */
	@ModelNodeBinding(detypedName = "reaper-period")
	public Long reaperPeriod() {
		return this.reaperPeriod;
	}

	/**
	 * How often the reaper will be run to check for timed out group bindings
	 * (only valid for LOCAL handlers).
	 */
	@SuppressWarnings("unchecked")
	public T reaperPeriod(java.lang.Long value) {
		Object oldValue = this.reaperPeriod;
		this.reaperPeriod = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("reaperPeriod", oldValue, value);
		return (T) this;
	}

	/**
	 * How long to wait for a handling decision to be made; an exception will be
	 * thrown during the send if this timeout is reached, ensuring that strict
	 * ordering is kept.
	 */
	@ModelNodeBinding(detypedName = "timeout")
	public Long timeout() {
		return this.timeout;
	}

	/**
	 * How long to wait for a handling decision to be made; an exception will be
	 * thrown during the send if this timeout is reached, ensuring that strict
	 * ordering is kept.
	 */
	@SuppressWarnings("unchecked")
	public T timeout(java.lang.Long value) {
		Object oldValue = this.timeout;
		this.timeout = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("timeout", oldValue, value);
		return (T) this;
	}

	/**
	 * Whether the handler is the single "Local" handler for the cluster, which
	 * makes handling decisions, or a "Remote" handler which converses with the
	 * local handler.
	 */
	@ModelNodeBinding(detypedName = "type")
	public Type type() {
		return this.type;
	}

	/**
	 * Whether the handler is the single "Local" handler for the cluster, which
	 * makes handling decisions, or a "Remote" handler which converses with the
	 * local handler.
	 */
	@SuppressWarnings("unchecked")
	public T type(Type value) {
		Object oldValue = this.type;
		this.type = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("type", oldValue, value);
		return (T) this;
	}
}