package org.wildfly.swarm.config.security.security_domain.audit;

import org.wildfly.swarm.config.security.security_domain.audit.ProviderModule;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface ProviderModuleConsumer<T extends ProviderModule<T>> {

	/**
	 * Configure a pre-constructed instance of ProviderModule resource
	 * 
	 * @parameter Instance of ProviderModule to configure
	 * @return nothing
	 */
	void accept(T value);

	default ProviderModuleConsumer<T> andThen(ProviderModuleConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}