/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.common;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import org.drools.core.RuleBaseConfiguration;
import org.drools.core.WorkingMemoryEntryPoint;
import org.drools.core.base.TraitHelper;
import org.drools.core.beliefsystem.BeliefSet;
import org.drools.core.common.ClassAwareObjectStore;
import org.drools.core.common.EqualityKey;
import org.drools.core.common.EventFactHandle;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.InternalWorkingMemoryEntryPoint;
import org.drools.core.common.ObjectStore;
import org.drools.core.common.ObjectTypeConfigurationRegistry;
import org.drools.core.common.PropagationContextFactory;
import org.drools.core.common.TruthMaintenanceSystem;
import org.drools.core.common.WorkingMemoryAction;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.factmodel.traits.TraitProxy;
import org.drools.core.factmodel.traits.TraitableBean;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.impl.StatefulKnowledgeSessionImpl;
import org.drools.core.reteoo.EntryPointNode;
import org.drools.core.reteoo.ObjectTypeConf;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.PropertySpecificUtil;
import org.drools.core.rule.EntryPointId;
import org.drools.core.spi.Activation;
import org.drools.core.spi.FactHandleFactory;
import org.drools.core.spi.PropagationContext;
import org.drools.core.util.bitmask.BitMask;
import org.kie.api.runtime.ObjectFilter;
import org.kie.api.runtime.rule.FactHandle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NamedEntryPoint
implements InternalWorkingMemoryEntryPoint,
WorkingMemoryEntryPoint,
PropertyChangeListener {
    protected static final transient Logger log = LoggerFactory.getLogger(NamedEntryPoint.class);
    protected static final Class<?>[] ADD_REMOVE_PROPERTY_CHANGE_LISTENER_ARG_TYPES = new Class[]{PropertyChangeListener.class};
    protected final Object[] addRemovePropertyChangeListenerArgs = new Object[]{this};
    private TruthMaintenanceSystem tms;
    protected ObjectStore objectStore;
    protected transient InternalKnowledgeBase kBase;
    protected EntryPointId entryPoint;
    protected EntryPointNode entryPointNode;
    private ObjectTypeConfigurationRegistry typeConfReg;
    private final StatefulKnowledgeSessionImpl wm;
    private FactHandleFactory handleFactory;
    private PropagationContextFactory pctxFactory;
    protected final ReentrantLock lock;
    protected Set<InternalFactHandle> dynamicFacts = null;
    protected TraitHelper traitHelper;

    public NamedEntryPoint(EntryPointId entryPoint, EntryPointNode entryPointNode, StatefulKnowledgeSessionImpl wm) {
        this(entryPoint, entryPointNode, wm, new ReentrantLock());
    }

    public NamedEntryPoint(EntryPointId entryPoint, EntryPointNode entryPointNode, StatefulKnowledgeSessionImpl wm, ReentrantLock lock) {
        this.entryPoint = entryPoint;
        this.entryPointNode = entryPointNode;
        this.wm = wm;
        this.kBase = this.wm.getKnowledgeBase();
        this.lock = lock;
        this.typeConfReg = new ObjectTypeConfigurationRegistry(this.kBase);
        this.handleFactory = this.wm.getFactHandleFactory();
        this.pctxFactory = this.kBase.getConfiguration().getComponentFactory().getPropagationContextFactory();
        this.objectStore = new ClassAwareObjectStore(this.kBase.getConfiguration(), this.lock);
        this.traitHelper = new TraitHelper(wm, this);
    }

    public void lock() {
        this.lock.lock();
    }

    public void unlock() {
        this.lock.unlock();
    }

    @Override
    public void reset() {
        this.objectStore.clear();
    }

    @Override
    public ObjectStore getObjectStore() {
        return this.objectStore;
    }

    @Override
    public EntryPointNode getEntryPointNode() {
        return this.entryPointNode;
    }

    @Override
    public FactHandleFactory getHandleFactory() {
        return this.handleFactory;
    }

    @Override
    public FactHandle insert(Object object) {
        return this.insert(object, false, null, null);
    }

    @Override
    public FactHandle insert(Object object, boolean dynamic) {
        return this.insert(object, dynamic, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FactHandle insert(Object object, boolean dynamic, RuleImpl rule, Activation activation) {
        if (object == null) {
            return null;
        }
        try {
            this.wm.startOperation();
            ObjectTypeConf typeConf = this.typeConfReg.getObjectTypeConf(this.entryPoint, object);
            InternalFactHandle handle = null;
            PropagationContext propagationContext = this.pctxFactory.createPropagationContext(this.wm.getNextPropagationIdCounter(), 0, rule, activation == null ? null : activation.getTuple(), handle, this.entryPoint);
            if (this.wm.isSequential()) {
                handle = this.createHandle(object, typeConf);
                propagationContext.setFactHandle(handle);
                this.insert(handle, object, rule, activation, typeConf, propagationContext);
                InternalFactHandle internalFactHandle = handle;
                return internalFactHandle;
            }
            try {
                this.lock.lock();
                handle = this.objectStore.getHandleForObject(object);
                if (!typeConf.isTMSEnabled()) {
                    if (handle != null) {
                        InternalFactHandle internalFactHandle = handle;
                        return internalFactHandle;
                    }
                    handle = this.createHandle(object, typeConf);
                } else {
                    TruthMaintenanceSystem tms = this.getTruthMaintenanceSystem();
                    if (handle != null && handle.getEqualityKey().getStatus() == 1) {
                        InternalFactHandle internalFactHandle = handle;
                        return internalFactHandle;
                    }
                    EqualityKey key = tms.get(object);
                    if (key != null && key.getStatus() == 2) {
                        BeliefSet bs = handle.getEqualityKey().getBeliefSet();
                        bs.getBeliefSystem().stage(propagationContext, bs);
                    }
                    handle = this.createHandle(object, typeConf);
                    if (key == null) {
                        key = new EqualityKey(handle, 1);
                        tms.put(key);
                    } else {
                        key.addFactHandle(handle);
                    }
                    handle.setEqualityKey(key);
                }
                propagationContext.setFactHandle(handle);
                if (dynamic || typeConf.isDynamic()) {
                    this.addPropertyChangeListener(handle, dynamic);
                }
                this.insert(handle, object, rule, activation, typeConf, propagationContext);
            }
            finally {
                this.lock.unlock();
            }
            InternalFactHandle internalFactHandle = handle;
            return internalFactHandle;
        }
        finally {
            this.wm.endOperation();
        }
    }

    public void insert(InternalFactHandle handle, Object object, RuleImpl rule, Activation activation, ObjectTypeConf typeConf, PropagationContext pctx) {
        this.kBase.executeQueuedActions();
        this.wm.executeQueuedActionsForRete();
        if (activation != null) {
            activation.getPropagationContext().releaseResources();
        }
        PropagationContext propagationContext = pctx;
        if (pctx == null) {
            propagationContext = this.pctxFactory.createPropagationContext(this.wm.getNextPropagationIdCounter(), 0, rule, activation == null ? null : activation.getTuple(), handle, this.entryPoint);
        }
        this.objectStore.addHandle(handle, object);
        this.entryPointNode.assertObject(handle, propagationContext, typeConf, this.wm);
        propagationContext.evaluateActionQueue(this.wm);
        this.wm.getRuleRuntimeEventSupport().fireObjectInserted(propagationContext, handle, object, this.wm);
        this.wm.executeQueuedActionsForRete();
        if (rule == null) {
            this.wm.getAgenda().unstageActivations();
        }
    }

    @Override
    public void update(FactHandle factHandle, Object object) {
        InternalFactHandle handle = (InternalFactHandle)factHandle;
        this.update(handle, object, PropertySpecificUtil.allSetButTraitBitMask(), (Class<?>)Object.class, (Activation)null);
    }

    @Override
    public void update(FactHandle factHandle, Object object, BitMask mask, Class<?> modifiedClass, Activation activation) {
        InternalFactHandle handle = (InternalFactHandle)factHandle;
        this.update(handle, object, mask, modifiedClass, activation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InternalFactHandle update(InternalFactHandle handle, Object object, BitMask mask, Class<?> modifiedClass, Activation activation) {
        try {
            this.lock.lock();
            this.wm.startOperation();
            this.kBase.executeQueuedActions();
            if (handle.isDisconnected()) {
                handle = this.objectStore.reconnect(handle);
            }
            Object originalObject = handle.getObject();
            if (handle.getEntryPoint() != this) {
                throw new IllegalArgumentException("Invalid Entry Point. You updated the FactHandle on entry point '" + handle.getEntryPoint().getEntryPointId() + "' instead of '" + this.getEntryPointId() + "'");
            }
            ObjectTypeConf typeConf = this.typeConfReg.getObjectTypeConf(this.entryPoint, object);
            if (handle.getId() == -1 || object == null || handle.isEvent() && ((EventFactHandle)handle).isExpired()) {
                InternalFactHandle internalFactHandle = handle;
                return internalFactHandle;
            }
            if (activation != null) {
                activation.getPropagationContext().releaseResources();
            }
            if (originalObject != object || !RuleBaseConfiguration.AssertBehaviour.IDENTITY.equals(this.kBase.getConfiguration().getAssertBehaviour())) {
                this.objectStore.updateHandle(handle, object);
            }
            this.handleFactory.increaseFactHandleRecency(handle);
            RuleImpl rule = activation == null ? null : activation.getRule();
            PropagationContext propagationContext = this.pctxFactory.createPropagationContext(this.wm.getNextPropagationIdCounter(), 2, rule, activation == null ? null : activation.getTuple(), handle, this.entryPoint, mask, modifiedClass, null);
            if (typeConf.isTMSEnabled()) {
                EqualityKey newKey = this.tms.get(object);
                EqualityKey oldKey = handle.getEqualityKey();
                if ((oldKey.getStatus() == 2 || oldKey.getBeliefSet() != null) && newKey != oldKey) {
                    throw new IllegalStateException("Currently we cannot modify something that has mixed stated and justified equal objects. Rule " + activation.getRule().getName() + " attempted an illegal operation");
                }
                if (newKey == null) {
                    oldKey.removeFactHandle(handle);
                    newKey = new EqualityKey(handle, 1);
                    handle.setEqualityKey(newKey);
                    this.getTruthMaintenanceSystem().put(newKey);
                } else if (newKey != oldKey) {
                    oldKey.removeFactHandle(handle);
                    handle.setEqualityKey(newKey);
                    newKey.addFactHandle(handle);
                }
                if (oldKey.isEmpty() && oldKey.getLogicalFactHandle() == null) {
                    this.getTruthMaintenanceSystem().remove(oldKey);
                }
            }
            if (handle.isTraitable() && object != originalObject && object instanceof TraitableBean && originalObject instanceof TraitableBean) {
                this.traitHelper.replaceCore(handle, object, originalObject, propagationContext.getModificationMask(), object.getClass(), activation);
            }
            this.update(handle, object, originalObject, typeConf, rule, propagationContext);
        }
        finally {
            this.wm.endOperation();
            this.lock.unlock();
        }
        return handle;
    }

    public void update(InternalFactHandle handle, Object object, Object originalObject, ObjectTypeConf typeConf, RuleImpl rule, PropagationContext propagationContext) {
        this.entryPointNode.modifyObject(handle, propagationContext, typeConf, (InternalWorkingMemory)this.wm);
        propagationContext.evaluateActionQueue(this.wm);
        this.wm.getRuleRuntimeEventSupport().fireObjectUpdated(propagationContext, handle, originalObject, object, this.wm);
        this.wm.executeQueuedActionsForRete();
        if (rule == null) {
            this.wm.getAgenda().unstageActivations();
        }
    }

    @Override
    public void retract(FactHandle handle) {
        this.delete(handle);
    }

    public void delete(FactHandle handle) {
        this.delete(handle, null, null);
    }

    public void delete(FactHandle handle, FactHandle.State fhState) {
        this.delete(handle, null, null, fhState);
    }

    @Override
    public void delete(FactHandle factHandle, RuleImpl rule, Activation activation) {
        this.delete(factHandle, rule, activation, FactHandle.State.ALL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(FactHandle factHandle, RuleImpl rule, Activation activation, FactHandle.State fhState) {
        if (factHandle == null) {
            throw new IllegalArgumentException("FactHandle cannot be null ");
        }
        try {
            this.lock.lock();
            this.wm.startOperation();
            this.kBase.executeQueuedActions();
            InternalFactHandle handle = (InternalFactHandle)factHandle;
            if (handle.getId() == -1) {
                return;
            }
            if (handle.isDisconnected()) {
                handle = this.objectStore.reconnect(handle);
            }
            if (handle.getEntryPoint() != this) {
                throw new IllegalArgumentException("Invalid Entry Point. You updated the FactHandle on entry point '" + handle.getEntryPoint().getEntryPointId() + "' instead of '" + this.getEntryPointId() + "'");
            }
            EqualityKey key = handle.getEqualityKey();
            if (fhState.isStated()) {
                this.deleteStated(rule, activation, handle, key);
            }
            if (fhState.isLogical()) {
                this.deleteLogical(key);
            }
        }
        finally {
            this.wm.endOperation();
            this.lock.unlock();
        }
    }

    private void deleteStated(RuleImpl rule, Activation activation, InternalFactHandle handle, EqualityKey key) {
        Object object;
        ObjectTypeConf typeConf;
        if (key != null && key.getStatus() == 2) {
            return;
        }
        if (handle.isTraitable()) {
            this.traitHelper.deleteWMAssertedTraitProxies(handle, rule, activation);
        }
        if ((typeConf = this.typeConfReg.getObjectTypeConf(this.entryPoint, object = handle.getObject())).isSupportsPropertyChangeListeners()) {
            this.removePropertyChangeListener(handle, true);
        }
        if (activation != null) {
            activation.getPropagationContext().releaseResources();
        }
        PropagationContext propagationContext = this.delete(handle, object, typeConf, rule, activation);
        if (typeConf.isTMSEnabled() && key != null) {
            TruthMaintenanceSystem tms = this.getTruthMaintenanceSystem();
            key.removeFactHandle(handle);
            handle.setEqualityKey(null);
            if (key.isEmpty() && key.getLogicalFactHandle() == null) {
                tms.remove(key);
            } else if (key.getLogicalFactHandle() != null) {
                InternalFactHandle justifiedHandle = key.getLogicalFactHandle();
                BeliefSet bs = justifiedHandle.getEqualityKey().getBeliefSet();
                bs.getBeliefSystem().unstage(propagationContext, bs);
            }
        }
        this.handleFactory.destroyFactHandle(handle);
    }

    private void deleteLogical(EqualityKey key) {
        if (key != null && key.getStatus() == 2) {
            this.getTruthMaintenanceSystem().delete(key.getLogicalFactHandle());
        }
    }

    public PropagationContext delete(InternalFactHandle handle, Object object, ObjectTypeConf typeConf, RuleImpl rule, Activation activation) {
        PropagationContext propagationContext = this.pctxFactory.createPropagationContext(this.wm.getNextPropagationIdCounter(), 1, rule, activation == null ? null : activation.getTuple(), handle, this.entryPoint);
        this.entryPointNode.retractObject(handle, propagationContext, typeConf, this.wm);
        if (handle.isTraiting() && handle.getObject() instanceof TraitProxy) {
            ((TraitProxy)handle.getObject()).getObject().removeTrait(((TraitProxy)handle.getObject())._getTypeCode());
        } else if (handle.isTraitable()) {
            this.traitHelper.deleteWMAssertedTraitProxies(handle, rule, activation);
        }
        this.objectStore.removeHandle(handle);
        propagationContext.evaluateActionQueue(this.wm);
        this.wm.getRuleRuntimeEventSupport().fireObjectRetracted(propagationContext, handle, object, this.wm);
        this.wm.executeQueuedActionsForRete();
        if (rule == null) {
            this.wm.getAgenda().unstageActivations();
        }
        return propagationContext;
    }

    protected void addPropertyChangeListener(InternalFactHandle handle, boolean dynamicFlag) {
        Object object = handle.getObject();
        try {
            Method method = object.getClass().getMethod("addPropertyChangeListener", ADD_REMOVE_PROPERTY_CHANGE_LISTENER_ARG_TYPES);
            method.invoke(object, this.addRemovePropertyChangeListenerArgs);
            if (dynamicFlag) {
                if (this.dynamicFacts == null) {
                    this.dynamicFacts = new HashSet<InternalFactHandle>();
                }
                this.dynamicFacts.add(handle);
            }
        }
        catch (NoSuchMethodException e) {
            log.error("Warning: Method addPropertyChangeListener not found on the class " + object.getClass() + " so Drools will be unable to process JavaBean" + " PropertyChangeEvents on the asserted Object");
        }
        catch (IllegalArgumentException e) {
            log.error("Warning: The addPropertyChangeListener method on the class " + object.getClass() + " does not take" + " a simple PropertyChangeListener argument" + " so Drools will be unable to process JavaBean" + " PropertyChangeEvents on the asserted Object");
        }
        catch (IllegalAccessException e) {
            log.error("Warning: The addPropertyChangeListener method on the class " + object.getClass() + " is not public" + " so Drools will be unable to process JavaBean" + " PropertyChangeEvents on the asserted Object");
        }
        catch (InvocationTargetException e) {
            log.error("Warning: The addPropertyChangeListener method on the class " + object.getClass() + " threw an InvocationTargetException" + " so Drools will be unable to process JavaBean" + " PropertyChangeEvents on the asserted Object: " + e.getMessage());
        }
        catch (SecurityException e) {
            log.error("Warning: The SecurityManager controlling the class " + object.getClass() + " did not allow the lookup of a" + " addPropertyChangeListener method" + " so Drools will be unable to process JavaBean" + " PropertyChangeEvents on the asserted Object: " + e.getMessage());
        }
    }

    protected void removePropertyChangeListener(FactHandle handle, boolean removeFromSet) {
        Object object = null;
        try {
            object = ((InternalFactHandle)handle).getObject();
            if (this.dynamicFacts != null && removeFromSet) {
                this.dynamicFacts.remove(object);
            }
            if (object != null) {
                Method mehod = object.getClass().getMethod("removePropertyChangeListener", ADD_REMOVE_PROPERTY_CHANGE_LISTENER_ARG_TYPES);
                mehod.invoke(object, this.addRemovePropertyChangeListenerArgs);
            }
        }
        catch (NoSuchMethodException mehod) {
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Warning: The removePropertyChangeListener method on the class " + object.getClass() + " does not take a simple PropertyChangeListener argument so Drools will be unable to stop processing JavaBean" + " PropertyChangeEvents on the retracted Object");
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Warning: The removePropertyChangeListener method on the class " + object.getClass() + " is not public so Drools will be unable to stop processing JavaBean PropertyChangeEvents on the retracted Object");
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Warning: The removePropertyChangeL istener method on the class " + object.getClass() + " threw an InvocationTargetException so Drools will be unable to stop processing JavaBean" + " PropertyChangeEvents on the retracted Object: " + e.getMessage());
        }
        catch (SecurityException e) {
            throw new RuntimeException("Warning: The SecurityManager controlling the class " + object.getClass() + " did not allow the lookup of a removePropertyChangeListener method so Drools will be unable to stop processing JavaBean" + " PropertyChangeEvents on the retracted Object: " + e.getMessage());
        }
    }

    @Override
    public WorkingMemoryEntryPoint getWorkingMemoryEntryPoint(String name) {
        return this.wm.getWorkingMemoryEntryPoint(name);
    }

    @Override
    public ObjectTypeConfigurationRegistry getObjectTypeConfigurationRegistry() {
        return this.typeConfReg;
    }

    @Override
    public InternalKnowledgeBase getKnowledgeBase() {
        return this.kBase;
    }

    public FactHandle getFactHandle(Object object) {
        return this.objectStore.getHandleForObject(object);
    }

    @Override
    public EntryPointId getEntryPoint() {
        return this.entryPoint;
    }

    @Override
    public InternalWorkingMemory getInternalWorkingMemory() {
        return this.wm;
    }

    @Override
    public FactHandle getFactHandleByIdentity(Object object) {
        return this.objectStore.getHandleForObjectIdentity(object);
    }

    public Object getObject(FactHandle factHandle) {
        return this.objectStore.getObjectForHandle((InternalFactHandle)factHandle);
    }

    public <T extends FactHandle> Collection<T> getFactHandles() {
        return new StatefulKnowledgeSessionImpl.ObjectStoreWrapper(this.objectStore, null, 1);
    }

    public <T extends FactHandle> Collection<T> getFactHandles(ObjectFilter filter) {
        return new StatefulKnowledgeSessionImpl.ObjectStoreWrapper(this.objectStore, filter, 1);
    }

    public Collection<? extends Object> getObjects() {
        return new StatefulKnowledgeSessionImpl.ObjectStoreWrapper(this.objectStore, null, 0);
    }

    public Collection<? extends Object> getObjects(ObjectFilter filter) {
        return new StatefulKnowledgeSessionImpl.ObjectStoreWrapper(this.objectStore, filter, 0);
    }

    public String getEntryPointId() {
        return this.entryPoint.getEntryPointId();
    }

    public long getFactCount() {
        return this.objectStore.size();
    }

    private InternalFactHandle createHandle(Object object, ObjectTypeConf typeConf) {
        return this.handleFactory.newFactHandle(object, typeConf, this.wm, this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        Object object = event.getSource();
        FactHandle handle = this.getFactHandle(object);
        if (handle == null) {
            throw new RuntimeException("Update error: handle not found for object: " + object + ". Is it in the working memory?");
        }
        this.update(handle, object);
    }

    @Override
    public void dispose() {
        if (this.dynamicFacts != null) {
            for (InternalFactHandle handle : this.dynamicFacts) {
                this.removePropertyChangeListener(handle, false);
            }
            this.dynamicFacts = null;
        }
        for (ObjectTypeConf conf : this.typeConfReg.values()) {
            ObjectTypeNode otn;
            if (!conf.isDynamic() || !conf.isSupportsPropertyChangeListeners() || (otn = conf.getConcreteObjectTypeNode()) == null) continue;
            Iterator<InternalFactHandle> it = this.getInternalWorkingMemory().getNodeMemory(otn).iterator();
            while (it.hasNext()) {
                this.removePropertyChangeListener(it.next(), false);
            }
        }
    }

    public void enQueueWorkingMemoryAction(WorkingMemoryAction action) {
        this.wm.queueWorkingMemoryAction(action);
    }

    @Override
    public TruthMaintenanceSystem getTruthMaintenanceSystem() {
        if (this.tms == null) {
            this.tms = new TruthMaintenanceSystem(this.wm, this);
        }
        return this.tms;
    }

    public PropagationContextFactory getPctxFactory() {
        return this.pctxFactory;
    }

    public TraitHelper getTraitHelper() {
        return this.traitHelper;
    }
}

