/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache.infinispan.authorization;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.model.Resource;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.model.Scope;
import org.keycloak.authorization.store.PolicyStore;
import org.keycloak.authorization.store.ResourceServerStore;
import org.keycloak.authorization.store.ResourceStore;
import org.keycloak.authorization.store.ScopeStore;
import org.keycloak.authorization.store.StoreFactory;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakTransaction;
import org.keycloak.models.cache.authorization.CachedStoreFactoryProvider;
import org.keycloak.models.cache.infinispan.authorization.PolicyAdapter;
import org.keycloak.models.cache.infinispan.authorization.ResourceAdapter;
import org.keycloak.models.cache.infinispan.authorization.ResourceServerAdapter;
import org.keycloak.models.cache.infinispan.authorization.ScopeAdapter;
import org.keycloak.models.cache.infinispan.authorization.StoreFactoryCacheManager;
import org.keycloak.models.cache.infinispan.authorization.entities.CachedPolicy;
import org.keycloak.models.cache.infinispan.authorization.entities.CachedResource;
import org.keycloak.models.cache.infinispan.authorization.entities.CachedResourceServer;
import org.keycloak.models.cache.infinispan.authorization.entities.CachedScope;
import org.keycloak.models.cache.infinispan.authorization.entities.PolicyListQuery;
import org.keycloak.models.cache.infinispan.authorization.entities.PolicyQuery;
import org.keycloak.models.cache.infinispan.authorization.entities.PolicyResourceListQuery;
import org.keycloak.models.cache.infinispan.authorization.entities.PolicyScopeListQuery;
import org.keycloak.models.cache.infinispan.authorization.entities.ResourceListQuery;
import org.keycloak.models.cache.infinispan.authorization.entities.ResourceQuery;
import org.keycloak.models.cache.infinispan.authorization.entities.ResourceScopeListQuery;
import org.keycloak.models.cache.infinispan.authorization.entities.ScopeListQuery;
import org.keycloak.models.cache.infinispan.authorization.events.PolicyRemovedEvent;
import org.keycloak.models.cache.infinispan.authorization.events.PolicyUpdatedEvent;
import org.keycloak.models.cache.infinispan.authorization.events.ResourceRemovedEvent;
import org.keycloak.models.cache.infinispan.authorization.events.ResourceServerRemovedEvent;
import org.keycloak.models.cache.infinispan.authorization.events.ResourceServerUpdatedEvent;
import org.keycloak.models.cache.infinispan.authorization.events.ResourceUpdatedEvent;
import org.keycloak.models.cache.infinispan.authorization.events.ScopeRemovedEvent;
import org.keycloak.models.cache.infinispan.authorization.events.ScopeUpdatedEvent;
import org.keycloak.models.cache.infinispan.events.InvalidationEvent;
import org.keycloak.representations.idm.authorization.AbstractPolicyRepresentation;

public class StoreFactoryCacheSession
implements CachedStoreFactoryProvider {
    protected static final Logger logger = Logger.getLogger(StoreFactoryCacheSession.class);
    protected StoreFactoryCacheManager cache;
    protected boolean transactionActive;
    protected boolean setRollbackOnly;
    protected Map<String, ResourceServerAdapter> managedResourceServers = new HashMap<String, ResourceServerAdapter>();
    protected Map<String, ScopeAdapter> managedScopes = new HashMap<String, ScopeAdapter>();
    protected Map<String, ResourceAdapter> managedResources = new HashMap<String, ResourceAdapter>();
    protected Map<String, PolicyAdapter> managedPolicies = new HashMap<String, PolicyAdapter>();
    protected Set<String> invalidations = new HashSet<String>();
    protected Set<InvalidationEvent> invalidationEvents = new HashSet<InvalidationEvent>();
    protected boolean clearAll;
    protected final long startupRevision;
    protected StoreFactory delegate;
    protected KeycloakSession session;
    protected ResourceServerCache resourceServerCache;
    protected ScopeCache scopeCache;
    protected ResourceCache resourceCache;
    protected PolicyCache policyCache;

    public StoreFactoryCacheSession(StoreFactoryCacheManager cache, KeycloakSession session) {
        this.cache = cache;
        this.startupRevision = cache.getCurrentCounter();
        this.session = session;
        this.resourceServerCache = new ResourceServerCache();
        this.scopeCache = new ScopeCache();
        this.resourceCache = new ResourceCache();
        this.policyCache = new PolicyCache();
        session.getTransactionManager().enlistPrepare(this.getPrepareTransaction());
        session.getTransactionManager().enlistAfterCompletion(this.getAfterTransaction());
    }

    public ResourceServerStore getResourceServerStore() {
        return this.resourceServerCache;
    }

    public ScopeStore getScopeStore() {
        return this.scopeCache;
    }

    public ResourceStore getResourceStore() {
        return this.resourceCache;
    }

    public PolicyStore getPolicyStore() {
        return this.policyCache;
    }

    public void close() {
    }

    private KeycloakTransaction getPrepareTransaction() {
        return new KeycloakTransaction(){

            public void begin() {
                StoreFactoryCacheSession.this.transactionActive = true;
            }

            public void commit() {
            }

            public void rollback() {
                StoreFactoryCacheSession.this.setRollbackOnly = true;
                StoreFactoryCacheSession.this.transactionActive = false;
            }

            public void setRollbackOnly() {
                StoreFactoryCacheSession.this.setRollbackOnly = true;
            }

            public boolean getRollbackOnly() {
                return StoreFactoryCacheSession.this.setRollbackOnly;
            }

            public boolean isActive() {
                return StoreFactoryCacheSession.this.transactionActive;
            }
        };
    }

    private KeycloakTransaction getAfterTransaction() {
        return new KeycloakTransaction(){

            public void begin() {
                StoreFactoryCacheSession.this.transactionActive = true;
            }

            public void commit() {
                try {
                    if (StoreFactoryCacheSession.this.getDelegate() == null) {
                        return;
                    }
                    if (StoreFactoryCacheSession.this.clearAll) {
                        StoreFactoryCacheSession.this.cache.clear();
                    }
                    StoreFactoryCacheSession.this.runInvalidations();
                    StoreFactoryCacheSession.this.transactionActive = false;
                }
                finally {
                    StoreFactoryCacheSession.this.cache.endRevisionBatch();
                }
            }

            public void rollback() {
                try {
                    StoreFactoryCacheSession.this.setRollbackOnly = true;
                    StoreFactoryCacheSession.this.runInvalidations();
                    StoreFactoryCacheSession.this.transactionActive = false;
                }
                finally {
                    StoreFactoryCacheSession.this.cache.endRevisionBatch();
                }
            }

            public void setRollbackOnly() {
                StoreFactoryCacheSession.this.setRollbackOnly = true;
            }

            public boolean getRollbackOnly() {
                return StoreFactoryCacheSession.this.setRollbackOnly;
            }

            public boolean isActive() {
                return StoreFactoryCacheSession.this.transactionActive;
            }
        };
    }

    protected void runInvalidations() {
        for (String id : this.invalidations) {
            this.cache.invalidateObject(id);
        }
        this.cache.sendInvalidationEvents(this.session, this.invalidationEvents, "AUTHORIZATION_INVALIDATION_EVENTS");
    }

    public long getStartupRevision() {
        return this.startupRevision;
    }

    public boolean isInvalid(String id) {
        return this.invalidations.contains(id);
    }

    public void registerResourceServerInvalidation(String id) {
        this.cache.resourceServerUpdated(id, this.invalidations);
        ResourceServerAdapter adapter = this.managedResourceServers.get(id);
        if (adapter != null) {
            adapter.invalidateFlag();
        }
        this.invalidationEvents.add(ResourceServerUpdatedEvent.create(id));
    }

    public void registerScopeInvalidation(String id, String name, String serverId) {
        this.cache.scopeUpdated(id, name, serverId, this.invalidations);
        ScopeAdapter adapter = this.managedScopes.get(id);
        if (adapter != null) {
            adapter.invalidateFlag();
        }
        this.invalidationEvents.add(ScopeUpdatedEvent.create(id, name, serverId));
    }

    public void registerResourceInvalidation(String id, String name, String type, String uri, Set<String> scopes, String serverId, String owner) {
        this.cache.resourceUpdated(id, name, type, uri, scopes, serverId, owner, this.invalidations);
        ResourceAdapter adapter = this.managedResources.get(id);
        if (adapter != null) {
            adapter.invalidateFlag();
        }
        this.invalidationEvents.add(ResourceUpdatedEvent.create(id, name, type, uri, scopes, serverId, owner));
    }

    public void registerPolicyInvalidation(String id, String name, Set<String> resources, Set<String> scopes, String serverId) {
        Set<String> resourceTypes = this.getResourceTypes(resources, serverId);
        this.cache.policyUpdated(id, name, resources, resourceTypes, scopes, serverId, this.invalidations);
        PolicyAdapter adapter = this.managedPolicies.get(id);
        if (adapter != null) {
            adapter.invalidateFlag();
        }
        this.invalidationEvents.add(PolicyUpdatedEvent.create(id, name, resources, resourceTypes, scopes, serverId));
    }

    private Set<String> getResourceTypes(Set<String> resources, String serverId) {
        if (resources == null) {
            return Collections.emptySet();
        }
        return resources.stream().map(resourceId -> {
            Resource resource = this.getResourceStore().findById(resourceId, serverId);
            String type = resource.getType();
            if (type != null) {
                return type;
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    public ResourceServerStore getResourceServerStoreDelegate() {
        return this.getDelegate().getResourceServerStore();
    }

    public ScopeStore getScopeStoreDelegate() {
        return this.getDelegate().getScopeStore();
    }

    public ResourceStore getResourceStoreDelegate() {
        return this.getDelegate().getResourceStore();
    }

    public PolicyStore getPolicyStoreDelegate() {
        return this.getDelegate().getPolicyStore();
    }

    public static String getResourceServerByClientCacheKey(String clientId) {
        return "resource.server.client.id." + clientId;
    }

    public static String getScopeByNameCacheKey(String name, String serverId) {
        return "scope.name." + name + "." + serverId;
    }

    public static String getResourceByNameCacheKey(String name, String serverId) {
        return "resource.name." + name + "." + serverId;
    }

    public static String getResourceByOwnerCacheKey(String owner, String serverId) {
        return "resource.owner." + owner + "." + serverId;
    }

    public static String getResourceByTypeCacheKey(String type, String serverId) {
        return "resource.type." + type + "." + serverId;
    }

    public static String getResourceByUriCacheKey(String uri, String serverId) {
        return "resource.uri." + uri + "." + serverId;
    }

    public static String getResourceByScopeCacheKey(String scopeId, String serverId) {
        return "resource.scope." + scopeId + "." + serverId;
    }

    public static String getPolicyByNameCacheKey(String name, String serverId) {
        return "policy.name." + name + "." + serverId;
    }

    public static String getPolicyByResource(String resourceId, String serverId) {
        return "policy.resource." + resourceId + "." + serverId;
    }

    public static String getPolicyByResourceType(String type, String serverId) {
        return "policy.resource.type." + type + "." + serverId;
    }

    public static String getPolicyByScope(String scope, String serverId) {
        return "policy.scope." + scope + "." + serverId;
    }

    public StoreFactory getDelegate() {
        if (this.delegate != null) {
            return this.delegate;
        }
        this.delegate = (StoreFactory)this.session.getProvider(StoreFactory.class);
        return this.delegate;
    }

    protected class PolicyCache
    implements PolicyStore {
        protected PolicyCache() {
        }

        public Policy create(AbstractPolicyRepresentation representation, ResourceServer resourceServer) {
            Policy policy = StoreFactoryCacheSession.this.getPolicyStoreDelegate().create(representation, resourceServer);
            StoreFactoryCacheSession.this.registerPolicyInvalidation(policy.getId(), representation.getName(), representation.getResources(), representation.getScopes(), resourceServer.getId());
            return policy;
        }

        public void delete(String id) {
            if (id == null) {
                return;
            }
            Policy policy = this.findById(id, null);
            if (policy == null) {
                return;
            }
            StoreFactoryCacheSession.this.cache.invalidateObject(id);
            Set<String> resources = policy.getResources().stream().map(resource -> resource.getId()).collect(Collectors.toSet());
            ResourceServer resourceServer = policy.getResourceServer();
            Set resourceTypes = StoreFactoryCacheSession.this.getResourceTypes(resources, resourceServer.getId());
            Set<String> scopes = policy.getScopes().stream().map(scope -> scope.getId()).collect(Collectors.toSet());
            StoreFactoryCacheSession.this.invalidationEvents.add(PolicyRemovedEvent.create(id, policy.getName(), resources, resourceTypes, scopes, resourceServer.getId()));
            StoreFactoryCacheSession.this.cache.policyRemoval(id, policy.getName(), resources, resourceTypes, scopes, resourceServer.getId(), StoreFactoryCacheSession.this.invalidations);
            StoreFactoryCacheSession.this.getPolicyStoreDelegate().delete(id);
        }

        public Policy findById(String id, String resourceServerId) {
            if (id == null) {
                return null;
            }
            CachedPolicy cached = StoreFactoryCacheSession.this.cache.get(id, CachedPolicy.class);
            if (cached != null) {
                logger.tracev("by id cache hit: {0}", (Object)cached.getId());
            }
            boolean wasCached = false;
            if (cached == null) {
                Long loaded = StoreFactoryCacheSession.this.cache.getCurrentRevision(id);
                Policy model = StoreFactoryCacheSession.this.getPolicyStoreDelegate().findById(id, resourceServerId);
                if (model == null) {
                    return null;
                }
                if (StoreFactoryCacheSession.this.invalidations.contains(id)) {
                    return model;
                }
                cached = new CachedPolicy(loaded, model);
                StoreFactoryCacheSession.this.cache.addRevisioned(cached, StoreFactoryCacheSession.this.startupRevision);
                wasCached = true;
            } else {
                if (StoreFactoryCacheSession.this.invalidations.contains(id)) {
                    return StoreFactoryCacheSession.this.getPolicyStoreDelegate().findById(id, resourceServerId);
                }
                if (StoreFactoryCacheSession.this.managedPolicies.containsKey(id)) {
                    return StoreFactoryCacheSession.this.managedPolicies.get(id);
                }
            }
            PolicyAdapter adapter = new PolicyAdapter(cached, StoreFactoryCacheSession.this);
            StoreFactoryCacheSession.this.managedPolicies.put(id, adapter);
            return adapter;
        }

        public Policy findByName(String name, String resourceServerId) {
            if (name == null) {
                return null;
            }
            String cacheKey = StoreFactoryCacheSession.getPolicyByNameCacheKey(name, resourceServerId);
            List result = this.cacheQuery(cacheKey, PolicyListQuery.class, () -> {
                Policy policy = StoreFactoryCacheSession.this.getPolicyStoreDelegate().findByName(name, resourceServerId);
                if (policy == null) {
                    return Collections.emptyList();
                }
                return Arrays.asList(policy);
            }, (revision, policies) -> new PolicyListQuery((Long)revision, cacheKey, policies.stream().map(policy -> policy.getId()).collect(Collectors.toSet()), resourceServerId), resourceServerId);
            if (result.isEmpty()) {
                return null;
            }
            return (Policy)result.get(0);
        }

        public List<Policy> findByResourceServer(String resourceServerId) {
            return StoreFactoryCacheSession.this.getPolicyStoreDelegate().findByResourceServer(resourceServerId);
        }

        public List<Policy> findByResourceServer(Map<String, String[]> attributes, String resourceServerId, int firstResult, int maxResult) {
            return StoreFactoryCacheSession.this.getPolicyStoreDelegate().findByResourceServer(attributes, resourceServerId, firstResult, maxResult);
        }

        public List<Policy> findByResource(String resourceId, String resourceServerId) {
            String cacheKey = StoreFactoryCacheSession.getPolicyByResource(resourceId, resourceServerId);
            return this.cacheQuery(cacheKey, PolicyResourceListQuery.class, () -> StoreFactoryCacheSession.this.getPolicyStoreDelegate().findByResource(resourceId, resourceServerId), (revision, policies) -> new PolicyResourceListQuery((Long)revision, cacheKey, resourceId, policies.stream().map(policy -> policy.getId()).collect(Collectors.toSet()), resourceServerId), resourceServerId);
        }

        public List<Policy> findByResourceType(String resourceType, String resourceServerId) {
            String cacheKey = StoreFactoryCacheSession.getPolicyByResourceType(resourceType, resourceServerId);
            return this.cacheQuery(cacheKey, PolicyResourceListQuery.class, () -> StoreFactoryCacheSession.this.getPolicyStoreDelegate().findByResourceType(resourceType, resourceServerId), (revision, policies) -> new PolicyResourceListQuery((Long)revision, cacheKey, resourceType, policies.stream().map(policy -> policy.getId()).collect(Collectors.toSet()), resourceServerId), resourceServerId);
        }

        public List<Policy> findByScopeIds(List<String> scopeIds, String resourceServerId) {
            if (scopeIds == null) {
                return null;
            }
            ArrayList<Policy> result = new ArrayList<Policy>();
            for (String id : scopeIds) {
                String cacheKey = StoreFactoryCacheSession.getPolicyByScope(id, resourceServerId);
                result.addAll(this.cacheQuery(cacheKey, PolicyScopeListQuery.class, () -> StoreFactoryCacheSession.this.getPolicyStoreDelegate().findByScopeIds(Arrays.asList(id), resourceServerId), (revision, resources) -> new PolicyScopeListQuery((Long)revision, cacheKey, id, resources.stream().map(resource -> resource.getId()).collect(Collectors.toSet()), resourceServerId), resourceServerId));
            }
            return result;
        }

        public List<Policy> findByType(String type, String resourceServerId) {
            return StoreFactoryCacheSession.this.getPolicyStoreDelegate().findByType(type, resourceServerId);
        }

        public List<Policy> findDependentPolicies(String id, String resourceServerId) {
            return StoreFactoryCacheSession.this.getPolicyStoreDelegate().findDependentPolicies(id, resourceServerId);
        }

        private <R, Q extends PolicyQuery> List<R> cacheQuery(String cacheKey, Class<Q> queryType, Supplier<List<R>> resultSupplier, BiFunction<Long, List<R>, Q> querySupplier, String resourceServerId) {
            PolicyQuery query = (PolicyQuery)StoreFactoryCacheSession.this.cache.get(cacheKey, queryType);
            if (query != null) {
                logger.tracev("cache hit for key: {0}", (Object)cacheKey);
            }
            if (query == null) {
                Long loaded = StoreFactoryCacheSession.this.cache.getCurrentRevision(cacheKey);
                List<R> model = resultSupplier.get();
                if (model == null) {
                    return null;
                }
                if (StoreFactoryCacheSession.this.invalidations.contains(cacheKey)) {
                    return model;
                }
                query = (PolicyQuery)querySupplier.apply(loaded, model);
                StoreFactoryCacheSession.this.cache.addRevisioned(query, StoreFactoryCacheSession.this.startupRevision);
                return model;
            }
            if (query.isInvalid(StoreFactoryCacheSession.this.invalidations)) {
                return resultSupplier.get();
            }
            return query.getPolicies().stream().map(resourceId -> this.findById((String)resourceId, resourceServerId)).collect(Collectors.toList());
        }
    }

    protected class ResourceCache
    implements ResourceStore {
        protected ResourceCache() {
        }

        public Resource create(String name, ResourceServer resourceServer, String owner) {
            Resource resource = StoreFactoryCacheSession.this.getResourceStoreDelegate().create(name, resourceServer, owner);
            Resource cached = this.findById(resource.getId(), resourceServer.getId());
            StoreFactoryCacheSession.this.registerResourceInvalidation(resource.getId(), resource.getName(), resource.getType(), resource.getUri(), resource.getScopes().stream().map(scope -> scope.getId()).collect(Collectors.toSet()), resourceServer.getId(), resource.getOwner());
            return cached;
        }

        public void delete(String id) {
            if (id == null) {
                return;
            }
            Resource resource = this.findById(id, null);
            if (resource == null) {
                return;
            }
            StoreFactoryCacheSession.this.cache.invalidateObject(id);
            StoreFactoryCacheSession.this.invalidationEvents.add(ResourceRemovedEvent.create(id, resource.getName(), resource.getType(), resource.getUri(), resource.getOwner(), resource.getScopes().stream().map(scope -> scope.getId()).collect(Collectors.toSet()), resource.getResourceServer().getId()));
            StoreFactoryCacheSession.this.cache.resourceRemoval(id, resource.getName(), resource.getType(), resource.getUri(), resource.getOwner(), resource.getScopes().stream().map(scope -> scope.getId()).collect(Collectors.toSet()), resource.getResourceServer().getId(), StoreFactoryCacheSession.this.invalidations);
            StoreFactoryCacheSession.this.getResourceStoreDelegate().delete(id);
        }

        public Resource findById(String id, String resourceServerId) {
            if (id == null) {
                return null;
            }
            CachedResource cached = StoreFactoryCacheSession.this.cache.get(id, CachedResource.class);
            if (cached != null) {
                logger.tracev("by id cache hit: {0}", (Object)cached.getId());
            }
            boolean wasCached = false;
            if (cached == null) {
                Long loaded = StoreFactoryCacheSession.this.cache.getCurrentRevision(id);
                Resource model = StoreFactoryCacheSession.this.getResourceStoreDelegate().findById(id, resourceServerId);
                if (model == null) {
                    return null;
                }
                if (StoreFactoryCacheSession.this.invalidations.contains(id)) {
                    return model;
                }
                cached = new CachedResource(loaded, model);
                StoreFactoryCacheSession.this.cache.addRevisioned(cached, StoreFactoryCacheSession.this.startupRevision);
                wasCached = true;
            } else {
                if (StoreFactoryCacheSession.this.invalidations.contains(id)) {
                    return StoreFactoryCacheSession.this.getResourceStoreDelegate().findById(id, resourceServerId);
                }
                if (StoreFactoryCacheSession.this.managedResources.containsKey(id)) {
                    return StoreFactoryCacheSession.this.managedResources.get(id);
                }
            }
            ResourceAdapter adapter = new ResourceAdapter(cached, StoreFactoryCacheSession.this);
            StoreFactoryCacheSession.this.managedResources.put(id, adapter);
            return adapter;
        }

        public Resource findByName(String name, String resourceServerId) {
            if (name == null) {
                return null;
            }
            String cacheKey = StoreFactoryCacheSession.getResourceByNameCacheKey(name, resourceServerId);
            List result = this.cacheQuery(cacheKey, ResourceListQuery.class, () -> {
                Resource resource = StoreFactoryCacheSession.this.getResourceStoreDelegate().findByName(name, resourceServerId);
                if (resource == null) {
                    return Collections.emptyList();
                }
                return Arrays.asList(resource);
            }, (revision, resources) -> new ResourceListQuery((Long)revision, cacheKey, resources.stream().map(resource -> resource.getId()).collect(Collectors.toSet()), resourceServerId), resourceServerId);
            if (result.isEmpty()) {
                return null;
            }
            return (Resource)result.get(0);
        }

        public List<Resource> findByOwner(String ownerId, String resourceServerId) {
            String cacheKey = StoreFactoryCacheSession.getResourceByOwnerCacheKey(ownerId, resourceServerId);
            return this.cacheQuery(cacheKey, ResourceListQuery.class, () -> StoreFactoryCacheSession.this.getResourceStoreDelegate().findByOwner(ownerId, resourceServerId), (revision, resources) -> new ResourceListQuery((Long)revision, cacheKey, resources.stream().map(resource -> resource.getId()).collect(Collectors.toSet()), resourceServerId), resourceServerId);
        }

        public List<Resource> findByUri(String uri, String resourceServerId) {
            if (uri == null) {
                return null;
            }
            String cacheKey = StoreFactoryCacheSession.getResourceByUriCacheKey(uri, resourceServerId);
            return this.cacheQuery(cacheKey, ResourceListQuery.class, () -> StoreFactoryCacheSession.this.getResourceStoreDelegate().findByUri(uri, resourceServerId), (revision, resources) -> new ResourceListQuery((Long)revision, cacheKey, resources.stream().map(resource -> resource.getId()).collect(Collectors.toSet()), resourceServerId), resourceServerId);
        }

        public List<Resource> findByResourceServer(String resourceServerId) {
            return StoreFactoryCacheSession.this.getResourceStoreDelegate().findByResourceServer(resourceServerId);
        }

        public List<Resource> findByResourceServer(Map<String, String[]> attributes, String resourceServerId, int firstResult, int maxResult) {
            return StoreFactoryCacheSession.this.getResourceStoreDelegate().findByResourceServer(attributes, resourceServerId, firstResult, maxResult);
        }

        public List<Resource> findByScope(List<String> ids, String resourceServerId) {
            if (ids == null) {
                return null;
            }
            ArrayList<Resource> result = new ArrayList<Resource>();
            for (String id : ids) {
                String cacheKey = StoreFactoryCacheSession.getResourceByScopeCacheKey(id, resourceServerId);
                result.addAll(this.cacheQuery(cacheKey, ResourceScopeListQuery.class, () -> StoreFactoryCacheSession.this.getResourceStoreDelegate().findByScope(Arrays.asList(id), resourceServerId), (revision, resources) -> new ResourceScopeListQuery((Long)revision, cacheKey, id, resources.stream().map(resource -> resource.getId()).collect(Collectors.toSet()), resourceServerId), resourceServerId));
            }
            return result;
        }

        public List<Resource> findByType(String type, String resourceServerId) {
            if (type == null) {
                return null;
            }
            String cacheKey = StoreFactoryCacheSession.getResourceByTypeCacheKey(type, resourceServerId);
            return this.cacheQuery(cacheKey, ResourceListQuery.class, () -> StoreFactoryCacheSession.this.getResourceStoreDelegate().findByType(type, resourceServerId), (revision, resources) -> new ResourceListQuery((Long)revision, cacheKey, resources.stream().map(resource -> resource.getId()).collect(Collectors.toSet()), resourceServerId), resourceServerId);
        }

        private <R, Q extends ResourceQuery> List<R> cacheQuery(String cacheKey, Class<Q> queryType, Supplier<List<R>> resultSupplier, BiFunction<Long, List<R>, Q> querySupplier, String resourceServerId) {
            ResourceQuery query = (ResourceQuery)StoreFactoryCacheSession.this.cache.get(cacheKey, queryType);
            if (query != null) {
                logger.tracev("cache hit for key: {0}", (Object)cacheKey);
            }
            if (query == null) {
                Long loaded = StoreFactoryCacheSession.this.cache.getCurrentRevision(cacheKey);
                List<R> model = resultSupplier.get();
                if (model == null) {
                    return null;
                }
                if (StoreFactoryCacheSession.this.invalidations.contains(cacheKey)) {
                    return model;
                }
                query = (ResourceQuery)querySupplier.apply(loaded, model);
                StoreFactoryCacheSession.this.cache.addRevisioned(query, StoreFactoryCacheSession.this.startupRevision);
                return model;
            }
            if (query.isInvalid(StoreFactoryCacheSession.this.invalidations)) {
                return resultSupplier.get();
            }
            return query.getResources().stream().map(resourceId -> this.findById((String)resourceId, resourceServerId)).collect(Collectors.toList());
        }
    }

    protected class ScopeCache
    implements ScopeStore {
        protected ScopeCache() {
        }

        public Scope create(String name, ResourceServer resourceServer) {
            Scope scope = StoreFactoryCacheSession.this.getScopeStoreDelegate().create(name, resourceServer);
            StoreFactoryCacheSession.this.registerScopeInvalidation(scope.getId(), scope.getName(), resourceServer.getId());
            return scope;
        }

        public void delete(String id) {
            if (id == null) {
                return;
            }
            Scope scope = this.findById(id, null);
            if (scope == null) {
                return;
            }
            StoreFactoryCacheSession.this.cache.invalidateObject(id);
            StoreFactoryCacheSession.this.invalidationEvents.add(ScopeRemovedEvent.create(id, scope.getName(), scope.getResourceServer().getId()));
            StoreFactoryCacheSession.this.cache.scopeRemoval(id, scope.getName(), scope.getResourceServer().getId(), StoreFactoryCacheSession.this.invalidations);
            StoreFactoryCacheSession.this.getScopeStoreDelegate().delete(id);
        }

        public Scope findById(String id, String resourceServerId) {
            if (id == null) {
                return null;
            }
            CachedScope cached = StoreFactoryCacheSession.this.cache.get(id, CachedScope.class);
            if (cached != null) {
                logger.tracev("by id cache hit: {0}", (Object)cached.getId());
            }
            boolean wasCached = false;
            if (cached == null) {
                Long loaded = StoreFactoryCacheSession.this.cache.getCurrentRevision(id);
                Scope model = StoreFactoryCacheSession.this.getScopeStoreDelegate().findById(id, resourceServerId);
                if (model == null) {
                    return null;
                }
                if (StoreFactoryCacheSession.this.invalidations.contains(id)) {
                    return model;
                }
                cached = new CachedScope(loaded, model);
                StoreFactoryCacheSession.this.cache.addRevisioned(cached, StoreFactoryCacheSession.this.startupRevision);
                wasCached = true;
            } else {
                if (StoreFactoryCacheSession.this.invalidations.contains(id)) {
                    return StoreFactoryCacheSession.this.getScopeStoreDelegate().findById(id, resourceServerId);
                }
                if (StoreFactoryCacheSession.this.managedScopes.containsKey(id)) {
                    return StoreFactoryCacheSession.this.managedScopes.get(id);
                }
            }
            ScopeAdapter adapter = new ScopeAdapter(cached, StoreFactoryCacheSession.this);
            StoreFactoryCacheSession.this.managedScopes.put(id, adapter);
            return adapter;
        }

        public Scope findByName(String name, String resourceServerId) {
            if (name == null) {
                return null;
            }
            String cacheKey = StoreFactoryCacheSession.getScopeByNameCacheKey(name, resourceServerId);
            ScopeListQuery query = StoreFactoryCacheSession.this.cache.get(cacheKey, ScopeListQuery.class);
            if (query != null) {
                logger.tracev("scope by name cache hit: {0}", (Object)name);
            }
            if (query == null) {
                Long loaded = StoreFactoryCacheSession.this.cache.getCurrentRevision(cacheKey);
                Scope model = StoreFactoryCacheSession.this.getScopeStoreDelegate().findByName(name, resourceServerId);
                if (model == null) {
                    return null;
                }
                if (StoreFactoryCacheSession.this.invalidations.contains(model.getId())) {
                    return model;
                }
                query = new ScopeListQuery(loaded, cacheKey, model.getId(), resourceServerId);
                StoreFactoryCacheSession.this.cache.addRevisioned(query, StoreFactoryCacheSession.this.startupRevision);
                return model;
            }
            if (StoreFactoryCacheSession.this.invalidations.contains(cacheKey)) {
                return StoreFactoryCacheSession.this.getScopeStoreDelegate().findByName(name, resourceServerId);
            }
            String id = query.getScopes().iterator().next();
            if (StoreFactoryCacheSession.this.invalidations.contains(id)) {
                return StoreFactoryCacheSession.this.getScopeStoreDelegate().findByName(name, resourceServerId);
            }
            return this.findById(id, query.getResourceServerId());
        }

        public List<Scope> findByResourceServer(String id) {
            return StoreFactoryCacheSession.this.getScopeStoreDelegate().findByResourceServer(id);
        }

        public List<Scope> findByResourceServer(Map<String, String[]> attributes, String resourceServerId, int firstResult, int maxResult) {
            return StoreFactoryCacheSession.this.getScopeStoreDelegate().findByResourceServer(attributes, resourceServerId, firstResult, maxResult);
        }
    }

    protected class ResourceServerCache
    implements ResourceServerStore {
        protected ResourceServerCache() {
        }

        public ResourceServer create(String clientId) {
            ResourceServer server = StoreFactoryCacheSession.this.getResourceServerStoreDelegate().create(clientId);
            StoreFactoryCacheSession.this.registerResourceServerInvalidation(server.getId());
            return server;
        }

        public void delete(String id) {
            if (id == null) {
                return;
            }
            ResourceServer server = this.findById(id);
            if (server == null) {
                return;
            }
            StoreFactoryCacheSession.this.cache.invalidateObject(id);
            StoreFactoryCacheSession.this.invalidationEvents.add(ResourceServerRemovedEvent.create(id, server.getId()));
            StoreFactoryCacheSession.this.cache.resourceServerRemoval(id, StoreFactoryCacheSession.this.invalidations);
            StoreFactoryCacheSession.this.getResourceServerStoreDelegate().delete(id);
        }

        public ResourceServer findById(String id) {
            if (id == null) {
                return null;
            }
            CachedResourceServer cached = StoreFactoryCacheSession.this.cache.get(id, CachedResourceServer.class);
            if (cached != null) {
                logger.tracev("by id cache hit: {0}", (Object)cached.getId());
            }
            boolean wasCached = false;
            if (cached == null) {
                Long loaded = StoreFactoryCacheSession.this.cache.getCurrentRevision(id);
                ResourceServer model = StoreFactoryCacheSession.this.getResourceServerStoreDelegate().findById(id);
                if (model == null) {
                    return null;
                }
                if (StoreFactoryCacheSession.this.invalidations.contains(id)) {
                    return model;
                }
                cached = new CachedResourceServer(loaded, model);
                StoreFactoryCacheSession.this.cache.addRevisioned(cached, StoreFactoryCacheSession.this.startupRevision);
                wasCached = true;
            } else {
                if (StoreFactoryCacheSession.this.invalidations.contains(id)) {
                    return StoreFactoryCacheSession.this.getResourceServerStoreDelegate().findById(id);
                }
                if (StoreFactoryCacheSession.this.managedResourceServers.containsKey(id)) {
                    return StoreFactoryCacheSession.this.managedResourceServers.get(id);
                }
            }
            ResourceServerAdapter adapter = new ResourceServerAdapter(cached, StoreFactoryCacheSession.this);
            StoreFactoryCacheSession.this.managedResourceServers.put(id, adapter);
            return adapter;
        }
    }
}

