/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.query.impl;

import com.hazelcast.nio.serialization.Data;
import com.hazelcast.query.impl.BaseIndexStore;
import com.hazelcast.query.impl.ComparisonType;
import com.hazelcast.query.impl.IndexImpl;
import com.hazelcast.query.impl.MultiResultSet;
import com.hazelcast.query.impl.QueryableEntry;
import com.hazelcast.query.impl.SingleResultSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class UnsortedIndexStore
extends BaseIndexStore {
    private final ConcurrentMap<Data, QueryableEntry> recordsWithNullValue = new ConcurrentHashMap<Data, QueryableEntry>();
    private final ConcurrentMap<Comparable, ConcurrentMap<Data, QueryableEntry>> recordMap = new ConcurrentHashMap<Comparable, ConcurrentMap<Data, QueryableEntry>>(1000);

    @Override
    void newIndexInternal(Comparable newValue, QueryableEntry record) {
        if (newValue instanceof IndexImpl.NullObject) {
            this.recordsWithNullValue.put(record.getKeyData(), record);
        } else {
            this.mapAttributeToEntry(newValue, record);
        }
    }

    private void mapAttributeToEntry(Comparable attribute, QueryableEntry entry) {
        ConcurrentHashMap<Data, QueryableEntry> records = (ConcurrentHashMap<Data, QueryableEntry>)this.recordMap.get(attribute);
        if (records == null) {
            records = new ConcurrentHashMap<Data, QueryableEntry>(1, 0.75f, 1);
            this.recordMap.put(attribute, records);
        }
        records.put(entry.getKeyData(), entry);
    }

    @Override
    void removeIndexInternal(Comparable oldValue, Data indexKey) {
        if (oldValue instanceof IndexImpl.NullObject) {
            this.recordsWithNullValue.remove(indexKey);
        } else {
            this.removeMappingForAttribute(oldValue, indexKey);
        }
    }

    private void removeMappingForAttribute(Object attribute, Data indexKey) {
        ConcurrentMap records = (ConcurrentMap)this.recordMap.get(attribute);
        if (records != null) {
            records.remove(indexKey);
            if (records.size() == 0) {
                this.recordMap.remove(attribute);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        this.takeWriteLock();
        try {
            this.recordsWithNullValue.clear();
            this.recordMap.clear();
        }
        finally {
            this.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<QueryableEntry> getSubRecordsBetween(Comparable from, Comparable to) {
        this.takeReadLock();
        try {
            MultiResultSet results = this.createMultiResultSet();
            Comparable paramFrom = from;
            Comparable paramTo = to;
            int trend = paramFrom.compareTo(paramTo);
            if (trend == 0) {
                ConcurrentMap records = (ConcurrentMap)this.recordMap.get(paramFrom);
                if (records != null) {
                    results.addResultSet(records);
                }
                MultiResultSet multiResultSet = results;
                return multiResultSet;
            }
            if (trend < 0) {
                Comparable oldFrom = paramFrom;
                paramFrom = to;
                paramTo = oldFrom;
            }
            Set values = this.recordMap.keySet();
            for (Comparable value : values) {
                ConcurrentMap records;
                if (value.compareTo(paramFrom) > 0 || value.compareTo(paramTo) < 0 || (records = (ConcurrentMap)this.recordMap.get(value)) == null) continue;
                results.addResultSet(records);
            }
            MultiResultSet multiResultSet = results;
            return multiResultSet;
        }
        finally {
            this.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<QueryableEntry> getSubRecords(ComparisonType comparisonType, Comparable searchedValue) {
        this.takeReadLock();
        try {
            MultiResultSet results = this.createMultiResultSet();
            Set values = this.recordMap.keySet();
            for (Comparable value : values) {
                ConcurrentMap records;
                boolean valid;
                int result = searchedValue.compareTo(value);
                switch (comparisonType) {
                    case LESSER: {
                        valid = result > 0;
                        break;
                    }
                    case LESSER_EQUAL: {
                        valid = result >= 0;
                        break;
                    }
                    case GREATER: {
                        valid = result < 0;
                        break;
                    }
                    case GREATER_EQUAL: {
                        valid = result <= 0;
                        break;
                    }
                    case NOT_EQUAL: {
                        valid = result != 0;
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unrecognized comparisonType: " + (Object)((Object)comparisonType));
                    }
                }
                if (!valid || (records = (ConcurrentMap)this.recordMap.get(value)) == null) continue;
                results.addResultSet(records);
            }
            MultiResultSet multiResultSet = results;
            return multiResultSet;
        }
        finally {
            this.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConcurrentMap<Data, QueryableEntry> getRecordMap(Comparable value) {
        this.takeReadLock();
        try {
            if (value instanceof IndexImpl.NullObject) {
                ConcurrentMap<Data, QueryableEntry> concurrentMap = this.recordsWithNullValue;
                return concurrentMap;
            }
            ConcurrentMap concurrentMap = (ConcurrentMap)this.recordMap.get(value);
            return concurrentMap;
        }
        finally {
            this.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<QueryableEntry> getRecords(Comparable value) {
        this.takeReadLock();
        try {
            if (value instanceof IndexImpl.NullObject) {
                SingleResultSet singleResultSet = new SingleResultSet(this.recordsWithNullValue);
                return singleResultSet;
            }
            SingleResultSet singleResultSet = new SingleResultSet((ConcurrentMap)this.recordMap.get(value));
            return singleResultSet;
        }
        finally {
            this.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<QueryableEntry> getRecords(Set<Comparable> values) {
        this.takeReadLock();
        try {
            MultiResultSet results = this.createMultiResultSet();
            for (Comparable value : values) {
                ConcurrentMap records = value instanceof IndexImpl.NullObject ? this.recordsWithNullValue : (ConcurrentMap)this.recordMap.get(value);
                if (records == null) continue;
                results.addResultSet(records);
            }
            MultiResultSet multiResultSet = results;
            return multiResultSet;
        }
        finally {
            this.releaseReadLock();
        }
    }

    public String toString() {
        return "UnsortedIndexStore{recordMap=" + this.recordMap.size() + '}';
    }
}

