/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.keycloak.server;

import org.wildfly.swarm.config.KeycloakServer;
import org.wildfly.swarm.spi.api.Fraction;
import org.wildfly.swarm.spi.api.annotations.MarshalDMR;
import org.wildfly.swarm.spi.api.annotations.WildFlyExtension;
import org.wildfly.swarm.spi.api.annotations.WildFlySubsystem;

@WildFlyExtension(module="org.keycloak.keycloak-server-subsystem")
@WildFlySubsystem(value="keycloak-server")
@MarshalDMR
public class KeycloakServerFraction
extends KeycloakServer<KeycloakServerFraction>
implements Fraction {
    public static final String JPA = "jpa";
    public static final String DEFAULT = "default";
    public static final String BASIC = "basic";

    public Fraction applyDefaults() {
        this.webContext("auth");
        this.masterRealmName("master");
        this.scheduledTaskInterval(900L);
        this.spi("eventsStore", eventStore -> {
            eventStore.defaultProvider(JPA);
            eventStore.provider(JPA, provider -> {
                provider.enabled(Boolean.valueOf(true));
                provider.property("exclude-events", (Object)"[\"REFRESH_TOKEN\"]");
            });
        });
        this.spi("realm", spi -> spi.defaultProvider(JPA));
        this.spi("user", spi -> spi.defaultProvider(JPA));
        this.spi("userFederatedStorage", spi -> spi.defaultProvider(JPA));
        this.spi("userCache", spi -> spi.provider(DEFAULT, provider -> provider.enabled(Boolean.valueOf(true))));
        this.spi("userSessionPersister", spi -> spi.defaultProvider(JPA));
        this.spi("authorizationPersister", spi -> spi.defaultProvider(JPA));
        this.spi("timer", spi -> spi.defaultProvider(BASIC));
        this.spi("connectionsHttpClient", spi -> spi.provider(DEFAULT, provider -> provider.enabled(Boolean.valueOf(true))));
        this.spi("connectionsJpa", spi -> spi.provider(DEFAULT, provider -> {
            provider.enabled(Boolean.valueOf(true));
            provider.property("dataSource", (Object)"java:jboss/datasources/KeycloakDS");
            provider.property("initializeEmpty", (Object)"true");
            provider.property("migrationStrategy", (Object)"update");
            provider.property("migrationExport", (Object)"${user.dir}/keycloak-database-update.sql");
        }));
        this.spi("realmCache", spi -> spi.provider(DEFAULT, provider -> provider.enabled(Boolean.valueOf(true))));
        this.spi("connectionsInfinispan", spi -> {
            spi.defaultProvider(DEFAULT);
            spi.provider(DEFAULT, provider -> {
                provider.enabled(Boolean.valueOf(true));
                provider.property("cacheContainer", (Object)"java:comp/env/infinispan/Keycloak");
            });
        });
        this.spi("jta-lookup", spi -> {
            spi.defaultProvider("${keycloak.jta.lookup.provider:jboss}");
            spi.provider("jboss", provider -> provider.enabled(Boolean.valueOf(true)));
        });
        this.spi("publicKeyStorage", spi -> spi.provider("infinispan", provider -> {
            provider.enabled(Boolean.valueOf(true));
            provider.property("minTimeBetweenRequests", (Object)"10");
        }));
        return this;
    }
}

