/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.security;

import org.wildfly.swarm.config.Security;
import org.wildfly.swarm.config.security.Flag;
import org.wildfly.swarm.config.security.SecurityDomain;
import org.wildfly.swarm.spi.api.Fraction;
import org.wildfly.swarm.spi.api.annotations.MarshalDMR;
import org.wildfly.swarm.spi.api.annotations.WildFlyExtension;

@WildFlyExtension(module="org.jboss.as.security")
@MarshalDMR
public class SecurityFraction
extends Security<SecurityFraction>
implements Fraction<SecurityFraction> {
    private static final String DUMMY = "Dummy";

    public static SecurityFraction defaultSecurityFraction() {
        return new SecurityFraction().applyDefaults();
    }

    public SecurityFraction applyDefaults() {
        this.securityDomain("other", domain -> {
            domain.cacheType(SecurityDomain.CacheType.DEFAULT);
            domain.classicAuthentication(auth -> auth.loginModule("RealmDirect", module -> {
                module.code("RealmDirect");
                module.flag(Flag.REQUIRED);
                module.moduleOption("password-stacking", (Object)"useFirstPass");
            }));
        });
        this.securityDomain("jaspitest", domain -> {
            domain.cacheType(SecurityDomain.CacheType.DEFAULT);
            domain.jaspiAuthentication(auth -> {
                auth.loginModuleStack("dummy", stack -> stack.loginModule(DUMMY, module -> {
                    module.code(DUMMY);
                    module.flag(Flag.OPTIONAL);
                }));
                auth.authModule(DUMMY, module -> module.code(DUMMY));
            });
        });
        return this;
    }
}

