/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.keycloak.server;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;

@Address(value="/subsystem=keycloak-server/theme=*")
@ResourceType(value="theme")
public class Theme<T extends Theme<T>>
implements Keyed {
    private String key;
    private PropertyChangeSupport pcs;
    @AttributeDocumentation(value="If true, theme templates are cached.")
    private Boolean cachetemplates;
    @AttributeDocumentation(value="If true, themes are cached.")
    private Boolean cachethemes;
    @AttributeDocumentation(value="The default theme to use if no theme is specified for a realm.")
    private String attributeDefault;
    @AttributeDocumentation(value="Directory where themes can be located.")
    private String dir;
    @AttributeDocumentation(value="List of modules containing themes.")
    private List<String> modules;
    @AttributeDocumentation(value="Maximum time the browser should cache theme resources. A value of -1 will disable caching.")
    private Long staticmaxage;
    @AttributeDocumentation(value="The welcome theme.")
    private String welcometheme;

    public Theme(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    @ModelNodeBinding(detypedName="cacheTemplates")
    public Boolean cachetemplates() {
        return this.cachetemplates;
    }

    public T cachetemplates(Boolean value) {
        Boolean oldValue = this.cachetemplates;
        this.cachetemplates = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("cachetemplates", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="cacheThemes")
    public Boolean cachethemes() {
        return this.cachethemes;
    }

    public T cachethemes(Boolean value) {
        Boolean oldValue = this.cachethemes;
        this.cachethemes = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("cachethemes", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="default")
    public String attributeDefault() {
        return this.attributeDefault;
    }

    public T attributeDefault(String value) {
        String oldValue = this.attributeDefault;
        this.attributeDefault = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("attributeDefault", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="dir")
    public String dir() {
        return this.dir;
    }

    public T dir(String value) {
        String oldValue = this.dir;
        this.dir = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("dir", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="modules")
    public List<String> modules() {
        return this.modules;
    }

    public T modules(List<String> value) {
        List<String> oldValue = this.modules;
        this.modules = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("modules", oldValue, value);
        }
        return (T)this;
    }

    public T module(String value) {
        if (this.modules == null) {
            this.modules = new ArrayList<String>();
        }
        this.modules.add(value);
        return (T)this;
    }

    public T modules(String ... args) {
        this.modules(Arrays.stream(args).collect(Collectors.toList()));
        return (T)this;
    }

    @ModelNodeBinding(detypedName="staticMaxAge")
    public Long staticmaxage() {
        return this.staticmaxage;
    }

    public T staticmaxage(Long value) {
        Long oldValue = this.staticmaxage;
        this.staticmaxage = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("staticmaxage", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="welcomeTheme")
    public String welcometheme() {
        return this.welcometheme;
    }

    public T welcometheme(String value) {
        String oldValue = this.welcometheme;
        this.welcometheme = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("welcometheme", oldValue, value);
        }
        return (T)this;
    }
}

