/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.actiontoken.idpverifyemail;

import java.util.Collections;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.keycloak.TokenVerifier;
import org.keycloak.authentication.actiontoken.AbstractActionTokenHander;
import org.keycloak.authentication.actiontoken.ActionTokenContext;
import org.keycloak.authentication.actiontoken.TokenUtils;
import org.keycloak.authentication.actiontoken.idpverifyemail.IdpVerifyAccountLinkActionToken;
import org.keycloak.events.EventBuilder;
import org.keycloak.events.EventType;
import org.keycloak.forms.login.LoginFormsProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.services.Urls;
import org.keycloak.services.managers.AuthenticationSessionManager;
import org.keycloak.sessions.AuthenticationSessionModel;
import org.keycloak.sessions.AuthenticationSessionProvider;

public class IdpVerifyAccountLinkActionTokenHandler
extends AbstractActionTokenHander<IdpVerifyAccountLinkActionToken> {
    public IdpVerifyAccountLinkActionTokenHandler() {
        super("idp-verify-account-via-email", IdpVerifyAccountLinkActionToken.class, "staleCodeMessage", EventType.IDENTITY_PROVIDER_LINK_ACCOUNT, "invalid_token");
    }

    @Override
    public TokenVerifier.Predicate<? super IdpVerifyAccountLinkActionToken>[] getVerifiers(ActionTokenContext<IdpVerifyAccountLinkActionToken> tokenContext) {
        return TokenUtils.predicates(new TokenVerifier.Predicate[0]);
    }

    @Override
    public Response handleToken(IdpVerifyAccountLinkActionToken token, ActionTokenContext<IdpVerifyAccountLinkActionToken> tokenContext) {
        UserModel user = tokenContext.getAuthenticationSession().getAuthenticatedUser();
        EventBuilder event = tokenContext.getEvent();
        UriInfo uriInfo = tokenContext.getUriInfo();
        RealmModel realm = tokenContext.getRealm();
        KeycloakSession session = tokenContext.getSession();
        event.event(EventType.IDENTITY_PROVIDER_LINK_ACCOUNT).detail("email", user.getEmail()).detail("identity_provider", token.getIdentityProviderAlias()).detail("identity_provider_identity", token.getIdentityProviderUsername()).success();
        AuthenticationSessionModel authSession = tokenContext.getAuthenticationSession();
        if (tokenContext.isAuthenticationSessionFresh()) {
            token.setOriginalAuthenticationSessionId(token.getAuthenticationSessionId());
            token.setAuthenticationSessionId(authSession.getId());
            UriBuilder builder = Urls.actionTokenBuilder(uriInfo.getBaseUri(), token.serialize(session, realm, uriInfo));
            String confirmUri = builder.build(new Object[]{realm.getName()}).toString();
            return ((LoginFormsProvider)session.getProvider(LoginFormsProvider.class)).setAuthenticationSession(authSession).setSuccess("confirmAccountLinking", new Object[]{token.getIdentityProviderUsername(), token.getIdentityProviderAlias()}).setAttribute("actionUri", (Object)confirmUri).createInfoPage();
        }
        user.setEmailVerified(true);
        if (token.getOriginalAuthenticationSessionId() != null) {
            AuthenticationSessionManager asm = new AuthenticationSessionManager(session);
            asm.removeAuthenticationSession(realm, authSession, true);
            AuthenticationSessionProvider authSessProvider = session.authenticationSessions();
            authSession = authSessProvider.getAuthenticationSession(realm, token.getOriginalAuthenticationSessionId());
            if (authSession != null) {
                authSession.setAuthNote("VERIFY_ACCOUNT_IDP_USERNAME", token.getIdentityProviderUsername());
            } else {
                authSessProvider.updateNonlocalSessionAuthNotes(token.getAuthenticationSessionId(), Collections.singletonMap("VERIFY_ACCOUNT_IDP_USERNAME", token.getIdentityProviderUsername()));
            }
            return ((LoginFormsProvider)session.getProvider(LoginFormsProvider.class)).setAuthenticationSession(authSession).setSuccess("identityProviderLinkSuccess", new Object[]{token.getIdentityProviderAlias(), token.getIdentityProviderUsername()}).setAttribute("skipLink", (Object)true).createInfoPage();
        }
        authSession.setAuthNote("VERIFY_ACCOUNT_IDP_USERNAME", token.getIdentityProviderUsername());
        return tokenContext.brokerFlow(null, authSession.getAuthNote("current.flow.path"));
    }
}

