/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources;

import java.net.URI;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.jboss.logging.Logger;
import org.jboss.resteasy.spi.HttpRequest;
import org.keycloak.authentication.AuthenticationProcessor;
import org.keycloak.common.ClientConnection;
import org.keycloak.common.util.ObjectUtil;
import org.keycloak.events.EventBuilder;
import org.keycloak.forms.login.LoginFormsProvider;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.protocol.RestartLoginCookie;
import org.keycloak.services.ErrorPage;
import org.keycloak.services.ServicesLogger;
import org.keycloak.services.managers.AuthenticationSessionManager;
import org.keycloak.services.managers.ClientSessionCode;
import org.keycloak.services.resources.LoginActionsService;
import org.keycloak.services.util.AuthenticationFlowURLHelper;
import org.keycloak.services.util.BrowserHistoryHelper;
import org.keycloak.sessions.AuthenticationSessionModel;
import org.keycloak.sessions.CommonClientSessionModel;

public class SessionCodeChecks {
    private static final Logger logger = Logger.getLogger(SessionCodeChecks.class);
    private AuthenticationSessionModel authSession;
    private ClientSessionCode<AuthenticationSessionModel> clientCode;
    private Response response;
    private boolean actionRequest;
    private final RealmModel realm;
    private final UriInfo uriInfo;
    private final HttpRequest request;
    private final ClientConnection clientConnection;
    private final KeycloakSession session;
    private final EventBuilder event;
    private final String code;
    private final String execution;
    private final String clientId;
    private final String flowPath;

    public SessionCodeChecks(RealmModel realm, UriInfo uriInfo, HttpRequest request, ClientConnection clientConnection, KeycloakSession session, EventBuilder event, String code, String execution, String clientId, String flowPath) {
        this.realm = realm;
        this.uriInfo = uriInfo;
        this.request = request;
        this.clientConnection = clientConnection;
        this.session = session;
        this.event = event;
        this.code = code;
        this.execution = execution;
        this.clientId = clientId;
        this.flowPath = flowPath;
    }

    public AuthenticationSessionModel getAuthenticationSession() {
        return this.authSession;
    }

    private boolean failed() {
        return this.response != null;
    }

    public Response getResponse() {
        return this.response;
    }

    public ClientSessionCode<AuthenticationSessionModel> getClientCode() {
        return this.clientCode;
    }

    public boolean isActionRequest() {
        return this.actionRequest;
    }

    private boolean checkSsl() {
        if (this.uriInfo.getBaseUri().getScheme().equals("https")) {
            return true;
        }
        return !this.realm.getSslRequired().isRequired(this.clientConnection);
    }

    public AuthenticationSessionModel initialVerifyAuthSession() {
        UserSessionModel userSession;
        String sessionId;
        if (!this.checkSsl()) {
            this.event.error("ssl_required");
            this.response = ErrorPage.error(this.session, null, "httpsRequiredMessage", new Object[0]);
            return null;
        }
        if (!this.realm.isEnabled()) {
            this.event.error("realm_disabled");
            this.response = ErrorPage.error(this.session, null, "realmNotEnabledMessage", new Object[0]);
            return null;
        }
        AuthenticationSessionModel authSession = ClientSessionCode.getClientSession(this.code, this.session, this.realm, this.event, AuthenticationSessionModel.class);
        if (authSession != null) {
            return authSession;
        }
        logger.debugf("Will use client '%s' in back-to-application link", (Object)this.clientId);
        ClientModel client = null;
        if (this.clientId != null) {
            client = this.realm.getClientByClientId(this.clientId);
        }
        if (client != null) {
            this.session.getContext().setClient(client);
        }
        if ((sessionId = new AuthenticationSessionManager(this.session).getCurrentAuthenticationSessionId(this.realm)) != null && (userSession = this.session.sessions().getUserSession(this.realm, sessionId)) != null) {
            LoginFormsProvider loginForm = ((LoginFormsProvider)this.session.getProvider(LoginFormsProvider.class)).setAuthenticationSession(authSession).setSuccess("alreadyLoggedIn", new Object[0]);
            if (client == null) {
                loginForm.setAttribute("skipLink", (Object)true);
            }
            this.response = loginForm.createInfoPage();
            return null;
        }
        this.response = this.restartAuthenticationSessionFromCookie();
        return null;
    }

    public boolean initialVerify() {
        this.authSession = this.initialVerifyAuthSession();
        if (this.authSession == null) {
            return false;
        }
        this.response = BrowserHistoryHelper.getInstance().loadSavedResponse(this.session, this.authSession);
        if (this.response != null) {
            return false;
        }
        this.event.detail("code_id", this.authSession.getId());
        ClientModel client = this.authSession.getClient();
        if (client == null) {
            this.event.error("client_not_found");
            this.response = ErrorPage.error(this.session, this.authSession, "unknownLoginRequesterMessage", new Object[0]);
            this.clientCode.removeExpiredClientSession();
            return false;
        }
        this.event.client(client);
        this.session.getContext().setClient(client);
        if (!client.isEnabled()) {
            this.event.error("client_disabled");
            this.response = ErrorPage.error(this.session, this.authSession, "loginRequesterNotEnabledMessage", new Object[0]);
            this.clientCode.removeExpiredClientSession();
            return false;
        }
        if (this.code == null) {
            String lastExecFromSession = this.authSession.getAuthNote("current.authentication.execution");
            String lastFlow = this.authSession.getAuthNote("current.flow.path");
            if (this.execution == null && !this.flowPath.equals(lastFlow)) {
                logger.debugf("Transition between flows! Current flow: %s, Previous flow: %s", (Object)this.flowPath, (Object)lastFlow);
                if (CommonClientSessionModel.Action.AUTHENTICATE.name().equals(this.authSession.getAction())) {
                    this.authSession.setAuthNote("current.flow.path", this.flowPath);
                    this.authSession.removeAuthNote("current.authentication.execution");
                    lastExecFromSession = null;
                }
            }
            if (this.execution == null || this.execution.equals(lastExecFromSession)) {
                this.clientCode = new ClientSessionCode<AuthenticationSessionModel>(this.session, this.realm, this.authSession);
                this.actionRequest = false;
                if (this.execution == null && lastExecFromSession != null) {
                    logger.debugf("Parameter 'execution' is not in the request, but flow wasn't changed. Will update browser history", new Object[0]);
                    this.request.setAttribute("SHOULD_UPDATE_BROWSER_HISTORY", (Object)true);
                }
                return true;
            }
            this.response = this.showPageExpired(this.authSession);
            return false;
        }
        ClientSessionCode.ParseResult<AuthenticationSessionModel> result = ClientSessionCode.parseResult(this.code, this.session, this.realm, this.event, AuthenticationSessionModel.class);
        this.clientCode = result.getCode();
        if (this.clientCode == null) {
            if (ObjectUtil.isEqualOrBothNull((Object)this.execution, (Object)this.authSession.getAuthNote("current.authentication.execution"))) {
                String latestFlowPath = this.authSession.getAuthNote("current.flow.path");
                URI redirectUri = this.getLastExecutionUrl(latestFlowPath, this.execution, client.getClientId());
                logger.debugf("Invalid action code, but execution matches. So just redirecting to %s", (Object)redirectUri);
                this.authSession.setAuthNote("forwardedErrorMessage", "expiredActionMessage");
                this.response = Response.status((Response.Status)Response.Status.FOUND).location(redirectUri).build();
            } else {
                this.response = this.showPageExpired(this.authSession);
            }
            return false;
        }
        this.actionRequest = true;
        if (this.execution != null) {
            this.authSession.setAuthNote("last.processed.execution", this.execution);
        }
        return true;
    }

    public boolean verifyActiveAndValidAction(String expectedAction, ClientSessionCode.ActionType actionType) {
        if (this.failed()) {
            return false;
        }
        if (!this.isActionActive(actionType)) {
            return false;
        }
        if (!this.clientCode.isValidAction(expectedAction)) {
            AuthenticationSessionModel authSession = this.getAuthenticationSession();
            if (CommonClientSessionModel.Action.REQUIRED_ACTIONS.name().equals(authSession.getAction())) {
                logger.debugf("Incorrect action '%s' . User authenticated already.", (Object)authSession.getAction());
                this.response = this.showPageExpired(authSession);
                return false;
            }
            logger.errorf("Bad action. Expected action '%s', current action '%s'", (Object)expectedAction, (Object)authSession.getAction());
            this.response = ErrorPage.error(this.session, authSession, "expiredCodeMessage", new Object[0]);
            return false;
        }
        return true;
    }

    private boolean isActionActive(ClientSessionCode.ActionType actionType) {
        if (!this.clientCode.isActionActive(actionType)) {
            this.event.clone().error("expired_code");
            AuthenticationProcessor.resetFlow(this.authSession, "authenticate");
            this.authSession.setAuthNote("forwardedErrorMessage", "loginTimeout");
            URI redirectUri = this.getLastExecutionUrl("authenticate", null, this.authSession.getClient().getClientId());
            logger.debugf("Flow restart after timeout. Redirecting to %s", (Object)redirectUri);
            this.response = Response.status((Response.Status)Response.Status.FOUND).location(redirectUri).build();
            return false;
        }
        return true;
    }

    public boolean verifyRequiredAction(String executedAction) {
        if (this.failed()) {
            return false;
        }
        if (!this.clientCode.isValidAction(CommonClientSessionModel.Action.REQUIRED_ACTIONS.name())) {
            logger.debugf("Expected required action, but session action is '%s' . Showing expired page now.", (Object)this.authSession.getAction());
            this.event.error("invalid_code");
            this.response = this.showPageExpired(this.authSession);
            return false;
        }
        if (!this.isActionActive(ClientSessionCode.ActionType.USER)) {
            return false;
        }
        if (this.actionRequest) {
            String currentRequiredAction = this.authSession.getAuthNote("current.authentication.execution");
            if (executedAction == null || !executedAction.equals(currentRequiredAction)) {
                logger.debug((Object)"required action doesn't match current required action");
                this.response = this.redirectToRequiredActions(currentRequiredAction);
                return false;
            }
        }
        return true;
    }

    private Response restartAuthenticationSessionFromCookie() {
        logger.debug((Object)"Authentication session not found. Trying to restart from cookie.");
        AuthenticationSessionModel authSession = null;
        try {
            authSession = RestartLoginCookie.restartSession(this.session, this.realm);
        }
        catch (Exception e) {
            ServicesLogger.LOGGER.failedToParseRestartLoginCookie(e);
        }
        if (authSession != null) {
            this.event.clone();
            this.event.detail("restart_after_timeout", "true");
            this.event.error("expired_code");
            String warningMessage = "loginTimeout";
            authSession.setAuthNote("forwardedErrorMessage", warningMessage);
            String flowPath = authSession.getClientNote("APP_INITIATED_FLOW");
            if (flowPath == null) {
                flowPath = "authenticate";
            }
            URI redirectUri = this.getLastExecutionUrl(flowPath, null, authSession.getClient().getClientId());
            logger.debugf("Authentication session restart from cookie succeeded. Redirecting to %s", (Object)redirectUri);
            return Response.status((Response.Status)Response.Status.FOUND).location(redirectUri).build();
        }
        this.event.error("invalid_code");
        return ErrorPage.error(this.session, authSession, "invalidCodeMessage", new Object[0]);
    }

    private Response redirectToRequiredActions(String action) {
        UriBuilder uriBuilder = LoginActionsService.loginActionsBaseUrl(this.uriInfo).path("required-action");
        if (action != null) {
            uriBuilder.queryParam("execution", new Object[]{action});
        }
        ClientModel client = this.authSession.getClient();
        uriBuilder.queryParam("client_id", new Object[]{client.getClientId()});
        URI redirect = uriBuilder.build(new Object[]{this.realm.getName()});
        return Response.status((int)302).location(redirect).build();
    }

    private URI getLastExecutionUrl(String flowPath, String executionId, String clientId) {
        return new AuthenticationFlowURLHelper(this.session, this.realm, this.uriInfo).getLastExecutionUrl(flowPath, executionId, clientId);
    }

    private Response showPageExpired(AuthenticationSessionModel authSession) {
        return new AuthenticationFlowURLHelper(this.session, this.realm, this.uriInfo).showPageExpired(authSession);
    }
}

