package org.wildfly.swarm.config.keycloak.server;

import org.wildfly.swarm.config.keycloak.server.Theme;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface ThemeConsumer<T extends Theme<T>> {

	/**
	 * Configure a pre-constructed instance of Theme resource
	 * 
	 * @parameter Instance of Theme to configure
	 * @return nothing
	 */
	void accept(T value);

	default ThemeConsumer<T> andThen(ThemeConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}