/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.impl.security.adapters;

import java.lang.reflect.Method;
import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import javax.naming.InitialContext;
import javax.security.auth.Subject;
import org.kie.server.api.security.SecurityAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSphereSecurityAdapter
implements SecurityAdapter {
    private static final Logger logger = LoggerFactory.getLogger(WebSphereSecurityAdapter.class);
    private Object registry;
    private Class subject;
    private boolean active;

    public WebSphereSecurityAdapter() {
        try {
            this.registry = InitialContext.doLookup("UserRegistry");
            this.subject = Class.forName("com.ibm.websphere.security.auth.WSSubject");
            this.active = true;
        }
        catch (Exception e) {
            this.active = false;
            logger.debug("Unable to look up UserRegistry in JNDI under key 'UserRegistry', disabling websphere adapter");
        }
    }

    public String getUser(Object ... params) {
        if (this.active) {
            try {
                String principal = this.getPrincipalFromSubject(params);
                if (principal == null) {
                    Method method = this.subject.getMethod("getCallerPrincipal", new Class[0]);
                    principal = (String)method.invoke(null, new Object[0]);
                }
                return principal;
            }
            catch (Exception e) {
                logger.debug("Unable to get user from subject due to {}", (Object)e.getMessage(), (Object)e);
            }
        }
        return null;
    }

    public List<String> getRoles(Object ... params) {
        ArrayList<String> proles = new ArrayList<String>();
        if (this.active) {
            if (this.registry == null) {
                return proles;
            }
            try {
                Method method = this.registry.getClass().getMethod("getGroupsForUser", String.class);
                List rolesIn = (List)method.invoke(this.registry, this.getUser(params));
                if (rolesIn != null) {
                    for (Object o : rolesIn) {
                        proles.add(o.toString());
                    }
                }
            }
            catch (Exception e) {
                logger.debug("Unable to get groups from registry due to {}", (Object)e.getMessage(), (Object)e);
            }
        }
        return proles;
    }

    protected String getPrincipalFromSubject(Object[] params) {
        if (params != null && params.length > 0) {
            try {
                for (Object p : params) {
                    Principal principal;
                    if (!(p instanceof Subject) || (principal = ((Subject)p).getPrincipals().iterator().next()) == null) continue;
                    try {
                        Method method = principal.getClass().getMethod("getUserName", new Class[0]);
                        return (String)method.invoke((Object)principal, new Object[0]);
                    }
                    catch (Exception e) {
                        return principal.getName();
                    }
                }
            }
            catch (Exception e) {
                logger.debug("Not able to find principal in params due to {}", (Object)e.getMessage());
            }
        }
        return null;
    }
}

