/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.container.runtime.cdi;

import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.util.AnnotationLiteral;
import javax.inject.Singleton;
import org.jboss.weld.literal.AnyLiteral;
import org.wildfly.swarm.bootstrap.performance.Performance;
import org.wildfly.swarm.internal.SocketBindingRequest;
import org.wildfly.swarm.spi.api.Customizer;
import org.wildfly.swarm.spi.api.SocketBindingGroup;
import org.wildfly.swarm.spi.api.cdi.CommonBean;
import org.wildfly.swarm.spi.api.cdi.CommonBeanBuilder;
import org.wildfly.swarm.spi.runtime.annotations.Pre;

public class SocketBindingExtension
implements Extension {
    private final List<SocketBindingRequest> bindings;

    public SocketBindingExtension(List<SocketBindingRequest> bindings) {
        this.bindings = bindings;
    }

    void afterBeanDiscovery(@Observes AfterBeanDiscovery abd, BeanManager beanManager) throws Exception {
        try (AutoCloseable handle = Performance.time((String)"SocketBindingExtension.afterBeanDiscovery");){
            for (SocketBindingRequest each : this.bindings) {
                Supplier<Customizer> supplier = () -> () -> {
                    Set groups = beanManager.getBeans(SocketBindingGroup.class, new Annotation[]{AnyLiteral.INSTANCE});
                    groups.stream().map(e -> {
                        CreationalContext ctx = beanManager.createCreationalContext((Contextual)e);
                        return (SocketBindingGroup)beanManager.getReference(e, SocketBindingGroup.class, ctx);
                    }).filter(group -> group.name().equals(each.socketBindingGroup())).findFirst().ifPresent(group -> group.socketBinding(each.socketBinding()));
                };
                CommonBean customizerBean = CommonBeanBuilder.newBuilder(Customizer.class).beanClass(SocketBindingExtension.class).scope(Singleton.class).addQualifier((Annotation)new AnnotationLiteral<Pre>(){}).addQualifier((Annotation)AnyLiteral.INSTANCE).createSupplier(supplier).addType(Customizer.class).addType(Object.class).build();
                abd.addBean((Bean)customizerBean);
            }
        }
    }
}

