/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.container.config;

import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.enterprise.inject.Vetoed;
import org.wildfly.swarm.container.config.ConfigNode;
import org.wildfly.swarm.spi.api.config.SimpleKey;

@Vetoed
public class MapConfigNodeFactory {
    private MapConfigNodeFactory() {
    }

    public static ConfigNode load(Map<String, ?> input) {
        ConfigNode config = new ConfigNode();
        MapConfigNodeFactory.load(config, input);
        return config;
    }

    protected static void load(ConfigNode config, Map<String, ?> input) {
        Set<String> keys = input.keySet();
        for (String key : keys) {
            Object value = input.get(key);
            ConfigNode child = MapConfigNodeFactory.load(value);
            config.child(key, (Object)child);
        }
    }

    protected static void load(ConfigNode config, List<?> input) {
        int num = input.size();
        for (int i = 0; i < num; ++i) {
            Object value = input.get(i);
            ConfigNode child = MapConfigNodeFactory.load(value);
            config.child(new SimpleKey("" + i), (Object)child);
        }
    }

    protected static ConfigNode load(Object value) {
        ConfigNode child = null;
        if (value instanceof Map) {
            child = new ConfigNode();
            MapConfigNodeFactory.load(child, (Map)value);
        } else if (value instanceof List) {
            child = new ConfigNode();
            MapConfigNodeFactory.load(child, (List)value);
        } else if (value instanceof String) {
            child = new ConfigNode("" + value);
        } else if (value instanceof Integer) {
            child = new ConfigNode("" + value);
        } else if (value instanceof Boolean) {
            child = new ConfigNode("" + value);
        } else if (value instanceof Float) {
            child = new ConfigNode("" + value);
        } else if (value instanceof Double) {
            child = new ConfigNode("" + value);
        }
        return child;
    }
}

