/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.shareddata.impl;

import io.vertx.core.shareddata.LocalMap;
import io.vertx.core.shareddata.impl.Checker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

class LocalMapImpl<K, V>
implements LocalMap<K, V> {
    private final ConcurrentMap<Object, LocalMap<?, ?>> maps;
    private final String name;
    private final ConcurrentMap<K, V> map = new ConcurrentHashMap();

    LocalMapImpl(String name, ConcurrentMap<Object, LocalMap<?, ?>> maps) {
        this.name = name;
        this.maps = maps;
    }

    @Override
    public V get(K key) {
        return Checker.copyIfRequired(this.map.get(key));
    }

    @Override
    public V put(K key, V value) {
        Checker.checkType(key);
        Checker.checkType(value);
        return this.map.put(key, value);
    }

    @Override
    public V remove(K key) {
        return Checker.copyIfRequired(this.map.remove(key));
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public V putIfAbsent(K key, V value) {
        Checker.checkType(key);
        Checker.checkType(value);
        return Checker.copyIfRequired(this.map.putIfAbsent(key, value));
    }

    @Override
    public boolean removeIfPresent(K key, V value) {
        return this.map.remove(key, value);
    }

    @Override
    public boolean replaceIfPresent(K key, V oldValue, V newValue) {
        Checker.checkType(key);
        Checker.checkType(oldValue);
        Checker.checkType(newValue);
        return this.map.replace(key, oldValue, newValue);
    }

    @Override
    public V replace(K key, V value) {
        Checker.checkType(key);
        Checker.checkType(value);
        return Checker.copyIfRequired(this.map.replace(key, value));
    }

    @Override
    public void close() {
        this.maps.remove(this.name);
    }

    @Override
    public Set<K> keySet() {
        HashSet keys = new HashSet(this.map.size());
        for (Object k : this.map.keySet()) {
            keys.add(Checker.copyIfRequired(k));
        }
        return keys;
    }

    @Override
    public Collection<V> values() {
        ArrayList values = new ArrayList(this.map.size());
        for (Object v : this.map.values()) {
            values.add(Checker.copyIfRequired(v));
        }
        return values;
    }
}

