/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.remote.rest.common;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.ws.rs.ApplicationPath;
import javax.ws.rs.core.Application;
import org.codehaus.jackson.jaxrs.JacksonJaxbJsonProvider;
import org.codehaus.jackson.map.AnnotationIntrospector;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.introspect.JacksonAnnotationIntrospector;
import org.codehaus.jackson.xc.JaxbAnnotationIntrospector;
import org.kie.server.remote.rest.common.resource.KieServerRestImpl;
import org.kie.server.services.api.KieServerExtension;
import org.kie.server.services.api.SupportedTransports;
import org.kie.server.services.impl.KieServerImpl;
import org.kie.server.services.impl.KieServerLocator;

@ApplicationPath(value="/")
public class KieServerApplication
extends Application {
    private final Set<Object> instances = new CopyOnWriteArraySet<Object>(){
        private static final long serialVersionUID = 1763183096852523317L;
        {
            KieServerImpl server = KieServerLocator.getInstance();
            this.add(new KieServerRestImpl(server));
            List extensions = server.getServerExtensions();
            for (KieServerExtension extension : extensions) {
                this.addAll(extension.getAppComponents(SupportedTransports.REST));
            }
            ObjectMapper mapper = new ObjectMapper();
            JaxbAnnotationIntrospector primary = new JaxbAnnotationIntrospector();
            JacksonAnnotationIntrospector secondary = new JacksonAnnotationIntrospector();
            AnnotationIntrospector.Pair introspectorPair = new AnnotationIntrospector.Pair((AnnotationIntrospector)primary, (AnnotationIntrospector)secondary);
            mapper.setDeserializationConfig(mapper.getDeserializationConfig().withAnnotationIntrospector((AnnotationIntrospector)introspectorPair));
            mapper.setSerializationConfig(mapper.getSerializationConfig().withAnnotationIntrospector((AnnotationIntrospector)introspectorPair));
            JacksonJaxbJsonProvider jaxbProvider = new JacksonJaxbJsonProvider();
            jaxbProvider.setMapper(mapper);
            this.add(jaxbProvider);
        }
    };

    public Set<Class<?>> getClasses() {
        return Collections.emptySet();
    }

    public Set<Object> getSingletons() {
        return this.instances;
    }
}

