/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.replicatedmap.impl.client;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.replicatedmap.impl.client.AbstractReplicatedMapClientRequest;
import com.hazelcast.replicatedmap.impl.operation.RemoveOperation;
import com.hazelcast.replicatedmap.impl.operation.VersionResponsePair;
import com.hazelcast.security.permission.ReplicatedMapPermission;
import com.hazelcast.spi.Operation;
import java.io.IOException;
import java.security.Permission;

public class ClientReplicatedMapRemoveRequest
extends AbstractReplicatedMapClientRequest {
    private Data key;

    public ClientReplicatedMapRemoveRequest() {
    }

    public ClientReplicatedMapRemoveRequest(String name, Data key) {
        super(name);
        this.key = key;
    }

    @Override
    protected Operation prepareOperation() {
        return new RemoveOperation(this.getMapName(), this.key);
    }

    @Override
    public void write(PortableWriter writer) throws IOException {
        super.write(writer);
        ObjectDataOutput out = writer.getRawDataOutput();
        out.writeData(this.key);
    }

    @Override
    public void read(PortableReader reader) throws IOException {
        super.read(reader);
        ObjectDataInput in = reader.getRawDataInput();
        this.key = in.readData();
    }

    @Override
    protected Object filter(Object response) {
        if (response instanceof VersionResponsePair) {
            VersionResponsePair pair = (VersionResponsePair)response;
            return pair.getResponse();
        }
        return response;
    }

    @Override
    public int getClassId() {
        return 7;
    }

    @Override
    public Permission getRequiredPermission() {
        return new ReplicatedMapPermission(this.getMapName(), "remove");
    }

    @Override
    public String getMethodName() {
        return "remove";
    }

    @Override
    public Object[] getParameters() {
        return new Object[]{this.key};
    }

    @Override
    protected int getPartition() {
        return this.getClientEngine().getPartitionService().getPartitionId(this.key);
    }
}

