/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache.infinispan.events;

import java.util.Set;
import org.keycloak.models.cache.infinispan.RealmCacheManager;
import org.keycloak.models.cache.infinispan.events.InvalidationEvent;
import org.keycloak.models.cache.infinispan.events.RealmCacheInvalidationEvent;

public class RoleRemovedEvent
extends InvalidationEvent
implements RealmCacheInvalidationEvent {
    private String roleId;
    private String roleName;
    private String containerId;

    public static RoleRemovedEvent create(String roleId, String roleName, String containerId) {
        RoleRemovedEvent event = new RoleRemovedEvent();
        event.roleId = roleId;
        event.roleName = roleName;
        event.containerId = containerId;
        return event;
    }

    @Override
    public String getId() {
        return this.roleId;
    }

    public String toString() {
        return String.format("RoleRemovedEvent [ roleId=%s, containerId=%s ]", this.roleId, this.containerId);
    }

    @Override
    public void addInvalidations(RealmCacheManager realmCache, Set<String> invalidations) {
        realmCache.roleRemoval(this.roleId, this.roleName, this.containerId, invalidations);
    }
}

